/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.http.HttpRequest;
import com.netscape.cmsutil.http.JssSSLSocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URLEncoder;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(OCSPPublisher.class);
    private static final String PROP_HOST = "host";
    private static final String PROP_PORT = "port";
    private static final String PROP_PATH = "path";
    private static final String PROP_NICK = "nickName";
    private static final String PROP_CLIENT_AUTH_ENABLE = "enableClientAuth";
    private ConfigStore mConfig;
    private String mHost = null;
    private String mPort = null;
    private String mPath = null;
    private String mNickname = null;
    private boolean mClientAuthEnabled = true;

    public String getImplName() {
        return "OCSPPublisher";
    }

    public String getDescription() {
        return "This publisher writes the CRL to CMS's OCSP server.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"host;string;Host of CMS's OCSP Secure agent service", "port;string;Port of CMS's OCSP Secure agent service", "path;string;URI of CMS's OCSP Secure agent service", "nickName;string;Nickname of cert used for client authentication", "enableClientAuth;boolean;Client Authentication enabled", "HELP_TOKEN;configuration-ldappublish-publisher-ocsppublisher", "HELP_TEXT;Publishes CRLs to a Online Certificate Status Manager, an OCSP responder provided by CMS."};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        String host = "";
        String port = "";
        String path = "";
        String nickname = "";
        String clientAuthEnabled = "";
        try {
            host = this.mConfig.getString(PROP_HOST);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        v.addElement("host=" + host);
        try {
            port = this.mConfig.getString(PROP_PORT);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        v.addElement("port=" + port);
        try {
            path = this.mConfig.getString(PROP_PATH);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        v.addElement("path=" + path);
        try {
            nickname = this.mConfig.getString(PROP_NICK);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        v.addElement("nickName=" + nickname);
        try {
            clientAuthEnabled = this.mConfig.getString(PROP_CLIENT_AUTH_ENABLE);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        v.addElement("enableClientAuth=" + clientAuthEnabled);
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        Object nickname = "";
        try {
            nickname = cs.getString("ca.subsystem.nickname", "");
            String tokenname = cs.getString("ca.subsystem.tokenname", "");
            if (!CryptoUtil.isInternalToken((String)tokenname)) {
                nickname = tokenname + ":" + (String)nickname;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        v.addElement("host=");
        v.addElement("port=");
        v.addElement("path=/ocsp/agent/ocsp/addCRL");
        v.addElement("enableClientAuth=true");
        v.addElement("nickName=" + (String)nickname);
        return v;
    }

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mHost = this.mConfig.getString(PROP_HOST, "");
        this.mPort = this.mConfig.getString(PROP_PORT, "");
        this.mPath = this.mConfig.getString(PROP_PATH, "");
        this.mNickname = this.mConfig.getString(PROP_NICK, "");
        this.mClientAuthEnabled = this.mConfig.getBoolean(PROP_CLIENT_AUTH_ENABLE, true);
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    protected Socket Connect(String host, boolean secure, JssSSLSocketFactory factory) {
        Socket socket = null;
        StringTokenizer st = new StringTokenizer(host, " ");
        while (st.hasMoreTokens()) {
            String hp = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(hp, ":");
            String h = st1.nextToken();
            int p = Integer.parseInt(st1.nextToken());
            try {
                socket = secure ? factory.makeSocket(h, p) : new Socket(h, p);
                return socket;
            }
            catch (Exception e) {
                logger.warn("OCSPPublisher: " + e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public synchronized void publish(LDAPConnection conn, String dn, Object object) throws ELdapException {
        try {
            String nextline;
            if (!(object instanceof X509CRL)) {
                return;
            }
            X509CRL crl = (X509CRL)object;
            boolean secure = true;
            String host = this.mHost;
            int port = Integer.parseInt(this.mPort);
            String path = this.mPath;
            String url = "https://" + host + ":" + port + path;
            logger.info("OCSPPublisher: Publishing CRL to " + url);
            StringBuffer query = new StringBuffer();
            query.append("crl=");
            query.append(URLEncoder.encode("-----BEGIN CERTIFICATE REVOCATION LIST-----\n", "UTF-8"));
            query.append(URLEncoder.encode(Utils.base64encode((byte[])crl.getEncoded(), (boolean)true), "UTF-8"));
            query.append(URLEncoder.encode("\n-----END CERTIFICATE REVOCATION LIST-----", "UTF-8"));
            query.append("&noui=true");
            Socket socket = null;
            CAEngine engine = CAEngine.getInstance();
            JssSSLSocketFactory factory = this.mClientAuthEnabled ? new JssSSLSocketFactory(this.mNickname) : new JssSSLSocketFactory();
            factory.addSocketListener((SSLSocketListener)engine.getClientSocketListener());
            if (this.mHost != null && this.mHost.indexOf(32) != -1) {
                while ((socket = this.Connect(this.mHost, secure, factory)) == null) {
                }
            } else {
                socket = secure ? factory.makeSocket(host, port) : new Socket(host, port);
            }
            if (socket == null) {
                logger.error("OCSPPublisher: Unable to connect to " + url);
                throw new ELdapException("Unable to connect to " + url);
            }
            HttpRequest httpReq = new HttpRequest();
            httpReq.setMethod("POST");
            httpReq.setURI(path);
            httpReq.setHeader("Connection", "Keep-Alive");
            httpReq.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpReq.setHeader("Content-Transfer-Encoding", "7bit");
            httpReq.setHeader("Content-Length", Integer.toString(query.length()));
            httpReq.setContent(query.toString());
            OutputStream os = socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, "UTF8");
            logger.debug("OCSPPublisher: start sending CRL");
            long startTime = new Date().getTime();
            logger.debug("OCSPPublisher: start CRL sending startTime=" + startTime);
            httpReq.write(outputStreamWriter);
            long endTime = new Date().getTime();
            logger.debug("OCSPPublisher: done CRL sending endTime=" + endTime + " diff=" + (endTime - startTime));
            logger.debug("OCSPPublisher: start getting response");
            BufferedReader dis = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String error = "";
            boolean status = false;
            while ((nextline = dis.readLine()) != null) {
                if (nextline.startsWith("status=") && nextline.substring(7, nextline.length()).equals("0")) {
                    status = true;
                }
                if (!nextline.startsWith("error=")) continue;
                error = nextline.substring(6, nextline.length());
            }
            dis.close();
            if (status) {
                logger.debug("OCSPPublisher: successful");
            } else {
                logger.warn("OCSPPublisher: Unable to publish CRL: " + error);
            }
        }
        catch (IOException e) {
            logger.warn("OCSPPublisher: Unable to publish CRL: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"PUBLISH_OCSP_PUBLISHER_ERROR", (Object[])new Object[]{e.toString()}));
        }
        catch (CRLException e) {
            logger.warn("OCSPPublisher: Unable to publish CRL: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"PUBLISH_OCSP_PUBLISHER_ERROR", (Object[])new Object[]{e.toString()}));
        }
        catch (Exception e) {
            logger.warn("OCSPPublisher: Unable to publish CRL: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"PUBLISH_OCSP_PUBLISHER_ERROR", (Object[])new Object[]{e.toString()}));
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object object) throws ELdapException {
    }
}

