/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.request.CertReqParser;
import com.netscape.cms.servlet.request.ProcessReq;
import com.netscape.cmscore.base.ArgBlock;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

@WebServlet(name="caProcessReq", urlPatterns={"/agent/ca/processReq"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="parser", value="CertReqParser.DETAIL_PARSER"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caProcessReq"), @WebInitParam(name="templatePath", value="/agent/ca/processReq.template"), @WebInitParam(name="resourceID", value="certServer.ca.request.enrollment"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr")})
public class CertProcessReq
extends ProcessReq {
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        String tmp = sc.getInitParameter("parser");
        if (tmp != null) {
            if (tmp.trim().equals("CertReqParser.NODETAIL_PARSER")) {
                this.mParser = CertReqParser.NODETAIL_PARSER;
            } else if (tmp.trim().equals("CertReqParser.DETAIL_PARSER")) {
                this.mParser = CertReqParser.DETAIL_PARSER;
            }
        }
    }

    public void addAuthorityName(ArgBlock header) throws EBaseException {
        header.addStringValue("localca", "yes");
    }

    public void addSigningAlgorithm(ArgBlock header) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        String[] allAlgorithms = ca.getCASigningAlgorithms();
        if (allAlgorithms == null) {
            logger.debug("CertProcessReq: Signing algorithms set to All algorithms");
            allAlgorithms = AlgorithmId.ALL_SIGNING_ALGORITHMS;
        } else {
            logger.debug("CertProcessReq: First signing algorithms is " + allAlgorithms[0]);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < allAlgorithms.length; ++i) {
            if (i > 0) {
                sb.append("+");
                sb.append(allAlgorithms[i]);
                continue;
            }
            sb.append(allAlgorithms[i]);
        }
        String validAlgorithms = sb.toString();
        header.addStringValue("validAlgorithms", validAlgorithms);
        String signingAlgorithm = ca.getDefaultAlgorithm();
        if (signingAlgorithm != null) {
            header.addStringValue("caSigningAlgorithm", signingAlgorithm);
        }
        header.addLongValue("defaultValidityLength", engine.getDefaultCertValidity() / 1000L);
        X509CertImpl caCert = ca.getCACert();
        if (caCert != null) {
            int caPathLen = caCert.getBasicConstraints();
            header.addIntegerValue("caPathLen", caPathLen);
        }
    }
}

