/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CAGenPendingTemplateFiller;
import com.netscape.cms.servlet.common.CMSLoadTemplate;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cmc.CMCStatusInfoV2;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.ResponseBody;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caCheckRequest", urlPatterns={"/ee/ca/checkRequest"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="templatePath", value="/ee/ca/requestStatus.template"), @WebInitParam(name="ID", value="caCheckRequest"), @WebInitParam(name="resourceID", value="certServer.ee.requestStatus")})
public class CheckRequest
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(CheckRequest.class);
    private static final long serialVersionUID = 2791195859767119636L;
    public static String FULL_RESPONSE = "cmcFullEnrollmentResponse";
    private static final String REQ_ID = "requestId";
    private static final String STATUS = "status";
    private static final String CREATE_ON = "createdOn";
    private static final String UPDATE_ON = "updatedOn";
    private static final String TPL_FILE = "requestStatus.template";
    private String mFormPath = null;

    public CMSRequest newCMSRequest() {
        return new CMSRequest();
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ca/requestStatus.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CMSLoadTemplate pendingLoadTemplate = (CMSLoadTemplate)this.mTemplates.get(CMSRequest.PENDING);
        this.mTemplates.put(CMSRequest.PENDING, new CMSLoadTemplate("pendingTemplate", "pendingTemplateFiller", pendingLoadTemplate.getTemplateName(), (ICMSTemplateFiller)new CAGenPendingTemplateFiller()));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(CMSRequest cmsReq) throws EBaseException {
        String group;
        logger.debug("checkRequest: in process!");
        SET transIds = null;
        SET sNonces = null;
        boolean isCMCReq = false;
        INTEGER bodyPartId = null;
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        EBaseException error = null;
        String requestId = req.getParameter(REQ_ID);
        String format = req.getParameter("format");
        logger.debug("checkRequest: requestId " + requestId);
        String queryPending = req.getParameter("queryPending");
        if (format != null && format.equals("cmc") && queryPending != null && !queryPending.equals("")) {
            try {
                isCMCReq = true;
                byte[] cmcBlob = Utils.base64decode((String)queryPending);
                ByteArrayInputStream cmcBlobIn = new ByteArrayInputStream(cmcBlob);
                ContentInfo cii = (ContentInfo)ContentInfo.getTemplate().decode((InputStream)cmcBlobIn);
                SignedData cmcFullReq = (SignedData)cii.getInterpretedContent();
                EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
                OBJECT_IDENTIFIER id = ci.getContentType();
                if (!id.equals((Object)OBJECT_IDENTIFIER.id_cct_PKIData)) throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_PKIDATA", (String[])new String[0]));
                if (!ci.hasContent()) {
                    throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_PKIDATA", (String[])new String[0]));
                }
                OCTET_STRING content = ci.getContent();
                ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
                PKIData pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
                SEQUENCE controlSequence = pkiData.getControlSequence();
                int numControls = controlSequence.size();
                for (int i = 0; i < numControls; ++i) {
                    TaggedAttribute taggedAttr = (TaggedAttribute)controlSequence.elementAt(i);
                    OBJECT_IDENTIFIER type = taggedAttr.getType();
                    if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_QueryPending)) {
                        bodyPartId = taggedAttr.getBodyPartID();
                        SET requestIds = taggedAttr.getValues();
                        int numReq = requestIds.size();
                        if (numReq <= 0) continue;
                        OCTET_STRING reqId = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)requestIds.elementAt(0)));
                        requestId = new String(reqId.toByteArray());
                        continue;
                    }
                    if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_transactionId)) {
                        transIds = taggedAttr.getValues();
                        continue;
                    }
                    if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_recipientNonce) || !type.equals((Object)OBJECT_IDENTIFIER.id_cmc_senderNonce)) continue;
                    sNonces = taggedAttr.getValues();
                }
            }
            catch (Exception e) {
                error = new EBaseException(e.toString());
            }
        }
        ArgBlock httpParams = cmsReq.getHttpParams();
        boolean importCert = httpParams.getValueAsBoolean("importCert", false);
        java.security.cert.X509Certificate[] mCACerts = null;
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        CertificateAuthority ca = engine.getCA();
        try {
            mCACerts = ca.getCACertChain().getChain();
        }
        catch (Exception e) {
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CA_CHAIN_NOT_AVAILABLE", (String[])new String[0]));
        }
        if (requestId == null || requestId.trim().equals("")) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_REQUEST_ID_PROVIDED", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_REQUEST_ID_PROVIDED", (String[])new String[0]));
        }
        try {
            new BigInteger(requestId);
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT_1", (Object[])new Object[]{requestId}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT_1", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)requestId)}));
        }
        Request r = this.requestRepository.readRequest(new RequestId(requestId));
        if (r == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_ID_NOT_FOUND_1", (Object[])new Object[]{requestId}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_ID_NOT_FOUND", (String[])new String[]{requestId}));
        }
        if (authToken != null && (group = authToken.getInString("group")) != null && group != "" && group.equals("Registration Manager Agents")) {
            boolean groupMatched = false;
            String requestOwner = r.getExtDataInString("requestOwner");
            if (requestOwner != null && requestOwner.equals(group)) {
                groupMatched = true;
            }
            if (!groupMatched) {
                logger.error(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT_1", (Object[])new Object[]{requestId.toString()}));
                throw new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT_1", (String[])new String[]{requestId}));
            }
        }
        RequestStatus status = r.getRequestStatus();
        String note = r.getExtDataInString("requestNotes");
        header.addStringValue("authority", "ca");
        header.addStringValue(REQ_ID, r.getRequestId().toString());
        header.addStringValue(STATUS, status.toString());
        header.addLongValue(CREATE_ON, r.getCreationTime().getTime() / 1000L);
        header.addLongValue(UPDATE_ON, r.getModificationTime().getTime() / 1000L);
        if (note != null && note.length() > 0) {
            header.addStringValue("requestNotes", CMSTemplate.escapeJavaScriptStringHTML((String)note));
        }
        String type = r.getRequestType();
        Integer result = r.getExtDataInInteger("Result");
        String profileId = r.getExtDataInString("profileId");
        if (profileId != null) {
            result = Request.RES_SUCCESS;
        }
        boolean bl = true;
        while (true) {
            int i;
            block56: {
                ArgBlock rarg;
                block53: {
                    int ii;
                    X509CertImpl[] certsInChain;
                    X509CertImpl[] certs;
                    block57: {
                        block58: {
                            block55: {
                                block54: {
                                    if (!bl || (bl = false)) break block54;
                                    if (type == null || !type.equals("enrollment") && !type.equals("renewal") || status == null || !status.equals((Object)RequestStatus.COMPLETE) || result == null || !result.equals(Request.RES_SUCCESS)) break block55;
                                    X509CertImpl[] o = r.getExtDataInCertArray("issuedCerts");
                                    if (profileId != null) {
                                        X509CertImpl[] impl = new X509CertImpl[]{r.getExtDataInCert("req_issued_cert")};
                                        o = impl;
                                    }
                                    if (o == null || !(o instanceof X509CertImpl[]) || (certs = o) == null || certs.length <= 0) break block55;
                                    i = 0;
                                }
                                if (i >= certs.length) break block55;
                                if (certs[i] == null) break block56;
                                rarg = new ArgBlock();
                                rarg.addBigIntegerValue("serialNumber", certs[i].getSerialNumber(), 16);
                                if (!importCert && !isCMCReq) break block53;
                                certsInChain = new X509CertImpl[1];
                                if (mCACerts == null) break block57;
                                break block58;
                            }
                            try {
                                ServletOutputStream out = resp.getOutputStream();
                                if (error != null) {
                                    cmsReq.setStatus(CMSRequest.ERROR);
                                    cmsReq.setError(error);
                                    return;
                                }
                                String xmlOutput = req.getParameter("xml");
                                if (xmlOutput != null && xmlOutput.equals("true")) {
                                    this.outputXML(resp, argSet);
                                    return;
                                }
                                resp.setContentType("text/html");
                                form.renderOutput((OutputStream)out, argSet);
                                cmsReq.setStatus(CMSRequest.SUCCESS);
                                return;
                            }
                            catch (IOException e) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
                            }
                        }
                        for (ii = 0; ii < mCACerts.length; ++ii) {
                            if (certs[i].equals((Object)mCACerts[ii])) {
                                certsInChain = new X509CertImpl[mCACerts.length];
                                break;
                            }
                            certsInChain = new X509CertImpl[mCACerts.length + 1];
                        }
                    }
                    certsInChain[0] = certs[i];
                    if (mCACerts != null) {
                        for (ii = 0; ii < mCACerts.length; ++ii) {
                            if (certs[i].equals((Object)mCACerts[ii])) continue;
                            certsInChain[ii + 1] = (X509CertImpl)mCACerts[ii];
                        }
                    }
                    try {
                        byte[] dig;
                        PKCS7 p7 = new PKCS7(new AlgorithmId[0], new org.mozilla.jss.netscape.security.pkcs.ContentInfo(new byte[0]), (java.security.cert.X509Certificate[])certsInChain, new org.mozilla.jss.netscape.security.pkcs.SignerInfo[0]);
                        byte[] p7Bytes = p7.getBytes();
                        String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
                        StringTokenizer tokenizer = null;
                        if (File.separator.equals("\\")) {
                            char[] nl = new char[]{'\n', '\r'};
                            String nlstr = new String(nl);
                            tokenizer = new StringTokenizer(p7Str, nlstr);
                        } else {
                            tokenizer = new StringTokenizer(p7Str, "\n");
                        }
                        StringBuffer res = new StringBuffer();
                        while (tokenizer.hasMoreTokens()) {
                            String elem = tokenizer.nextToken();
                            res.append(elem);
                        }
                        header.addStringValue("pkcs7ChainBase64", res.toString());
                        if (!isCMCReq) break block53;
                        SEQUENCE controlSeq = new SEQUENCE();
                        int bpid = 1;
                        SEQUENCE bpids = new SEQUENCE();
                        if (bodyPartId != null) {
                            bpids.addElement((ASN1Value)bodyPartId);
                        }
                        CMCStatusInfoV2 cmcStatusInfo = new CMCStatusInfoV2(0, bpids);
                        TaggedAttribute ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfo);
                        controlSeq.addElement((ASN1Value)ta);
                        if (transIds != null) {
                            ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_transactionId, transIds);
                            controlSeq.addElement((ASN1Value)ta);
                        }
                        if (sNonces != null) {
                            ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_recipientNonce, sNonces);
                            controlSeq.addElement((ASN1Value)ta);
                        }
                        String salt = jssSubsystem.generateSalt();
                        try {
                            MessageDigest SHA1Digest = MessageDigest.getInstance("SHA1");
                            dig = SHA1Digest.digest(salt.getBytes());
                        }
                        catch (NoSuchAlgorithmException ex) {
                            dig = salt.getBytes();
                        }
                        String b64E = Utils.base64encode((byte[])dig, (boolean)true);
                        String[] newNonce = new String[]{b64E};
                        ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_senderNonce, (ASN1Value)new OCTET_STRING(newNonce[0].getBytes()));
                        controlSeq.addElement((ASN1Value)ta);
                        ResponseBody rb = new ResponseBody(controlSeq, new SEQUENCE(), new SEQUENCE());
                        EncapsulatedContentInfo ci = new EncapsulatedContentInfo(OBJECT_IDENTIFIER.id_cct_PKIResponse, (ASN1Value)rb);
                        X509Certificate x509cert = ca.getCaX509Cert();
                        if (x509cert == null) {
                            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CMC_ERROR", (String[])new String[]{"No signing cert found."}));
                        }
                        X509CertImpl cert = new X509CertImpl(x509cert.getEncoded());
                        ByteArrayInputStream issuer1 = new ByteArrayInputStream(cert.getIssuerName().getEncoded());
                        Name issuer = (Name)Name.getTemplate().decode((InputStream)issuer1);
                        IssuerAndSerialNumber ias = new IssuerAndSerialNumber(issuer, new INTEGER(cert.getSerialNumber().toString()));
                        SignerIdentifier si = new SignerIdentifier(SignerIdentifier.ISSUER_AND_SERIALNUMBER, ias, null);
                        DigestAlgorithm digestAlg = null;
                        SignatureAlgorithm signAlg = null;
                        PrivateKey privKey = CryptoManager.getInstance().findPrivKeyByCert(x509cert);
                        PrivateKey.Type keyType = privKey.getType();
                        if (keyType.equals(PrivateKey.RSA)) {
                            signAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
                        } else if (keyType.equals(PrivateKey.DSA)) {
                            signAlg = SignatureAlgorithm.DSASignatureWithSHA1Digest;
                        }
                        MessageDigest SHADigest = null;
                        byte[] digest = null;
                        try {
                            SHADigest = MessageDigest.getInstance("SHA1");
                            digestAlg = DigestAlgorithm.SHA1;
                            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                            rb.encode((OutputStream)ostream);
                            digest = SHADigest.digest(ostream.toByteArray());
                        }
                        catch (NoSuchAlgorithmException ostream) {
                            // empty catch block
                        }
                        SignerInfo signInfo = new SignerInfo(si, null, null, OBJECT_IDENTIFIER.id_cct_PKIResponse, digest, signAlg, privKey);
                        SET signInfos = new SET();
                        signInfos.addElement((ASN1Value)signInfo);
                        SET digestAlgs = new SET();
                        if (digestAlg != null) {
                            AlgorithmIdentifier ai = new AlgorithmIdentifier(digestAlg.toOID(), null);
                            digestAlgs.addElement((ASN1Value)ai);
                        }
                        SET jsscerts = new SET();
                        for (int j = 0; j < certsInChain.length; ++j) {
                            ByteArrayInputStream is = new ByteArrayInputStream(certsInChain[j].getEncoded());
                            Certificate certJss = (Certificate)Certificate.getTemplate().decode((InputStream)is);
                            jsscerts.addElement((ASN1Value)certJss);
                        }
                        SignedData fResponse = new SignedData(digestAlgs, ci, jsscerts, null, signInfos);
                        ContentInfo fullResponse = new ContentInfo(ContentInfo.SIGNED_DATA, (ASN1Value)fResponse);
                        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                        fullResponse.encode((OutputStream)ostream);
                        byte[] fr = ostream.toByteArray();
                        header.addStringValue(FULL_RESPONSE, Utils.base64encode((byte[])fr, (boolean)true));
                    }
                    catch (Exception e) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_FORMING_PKCS7_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_FORMING_PKCS7_ERROR", (String[])new String[0]), e);
                    }
                }
                argSet.addRepeatRecord(rarg);
            }
            ++i;
        }
    }
}

