/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUnrevocationListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(LdapUnrevocationListener.class);
    private CAPublisherProcessor processor;

    public LdapUnrevocationListener(CAPublisherProcessor processor) {
        this.processor = processor;
    }

    public void init(Subsystem sys, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public void accept(Request r) {
        logger.info("LdapUnrevocationListener: Handling unrevoke request " + r.getRequestId().toHexString());
        X509CertImpl[] certs = r.getExtDataInCertArray("OLD_CERTS");
        if (certs == null || certs.length == 0 || certs[0] == null) {
            logger.warn("Nothing to publish for unrevocation request " + r.getRequestId().toHexString());
            return;
        }
        this.acceptX509(r, (Certificate[])certs);
    }

    public void acceptX509(Request r, Certificate[] certs) {
        CAEngine engine = CAEngine.getInstance();
        Integer[] results = new Integer[certs.length];
        Integer status = Request.RES_SUCCESS;
        for (int i = 0; i < certs.length; ++i) {
            X509CertImpl xcert = (X509CertImpl)certs[i];
            results[i] = Request.RES_ERROR;
            try {
                BigInteger serial = xcert.getSerialNumber();
                CertRecord certRecord = null;
                CertificateRepository certdb = engine.getCertificateRepository();
                if (certdb == null) {
                    logger.warn("LdapUnrevocationListener: Missing cert database");
                } else {
                    try {
                        certRecord = certdb.readCertificateRecord(serial);
                    }
                    catch (EBaseException e) {
                        logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_GET_CERT_RECORD", (Object[])new Object[]{serial.toString(16), e.toString()}), (Throwable)e);
                    }
                }
                MetaInfo metaInfo = null;
                String ridString = null;
                if (certRecord != null) {
                    metaInfo = (MetaInfo)certRecord.get("certMetaInfo");
                }
                if (metaInfo == null) {
                    logger.warn("LdapUnrevocationListener: Unable to get meta info for cert 0x" + serial.toString(16));
                } else {
                    ridString = (String)metaInfo.get("requestId");
                }
                Request req = null;
                if (ridString != null) {
                    RequestId rid = new RequestId(ridString);
                    req = engine.getRequestRepository().readRequest(rid);
                }
                this.processor.publishCert((X509Certificate)xcert, req);
                results[i] = Request.RES_SUCCESS;
                logger.debug("LdapUnrevocationListener: Published cert 0x" + xcert.getSerialNumber().toString(16));
                continue;
            }
            catch (ELdapException e) {
                status = Request.RES_ERROR;
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_PUBLISH", (Object[])new Object[]{xcert.getSerialNumber().toString(16), e.toString()}), (Throwable)e);
                continue;
            }
            catch (EBaseException e) {
                status = Request.RES_ERROR;
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_FIND", (Object[])new Object[]{xcert.getSerialNumber().toString(16), e.toString()}), (Throwable)e);
            }
        }
        r.setExtData("ldapPublishStatus", results);
        r.setExtData("ldapPublishOverAllStatus", status);
    }
}

