/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tks.TPSConnectorCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnectorRemoveCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TPSConnectorRemoveCLI.class);
    public TPSConnectorCLI tpsConnectorCLI;

    public TPSConnectorRemoveCLI(TPSConnectorCLI tpsConnectorCLI) {
        super("del", "Remove TPS connector from TKS", (CLI)tpsConnectorCLI);
        this.tpsConnectorCLI = tpsConnectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "host", true, "TPS host");
        option.setArgName("host");
        this.options.addOption(option);
        option = new Option(null, "port", true, "TPS port");
        option.setArgName("port");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String tpsHost = cmd.getOptionValue("host");
        String tpsPort = cmd.getOptionValue("port");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TPSConnectorClient tpsConnectorClient = this.tpsConnectorCLI.getTPSConnectorClient();
        tpsConnectorClient.deleteConnector(tpsHost, tpsPort);
        MainCLI.printMessage("Removed TPS connector \"" + tpsHost + ":" + tpsPort + "\"");
    }
}

