/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ModifyDNRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedRequestAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class TextFormattedModifyDNRequestAccessLogMessage
extends TextFormattedRequestAccessLogMessage
implements ModifyDNRequestAccessLogMessage {
    private static final long serialVersionUID = -4814940474132841630L;
    @Nullable
    private final Boolean deleteOldRDN;
    @Nullable
    private final String dn = this.getString(TextFormattedAccessLogFields.MODDN_ENTRY_DN);
    @Nullable
    private final String newRDN = this.getString(TextFormattedAccessLogFields.MODDN_NEW_RDN);
    @Nullable
    private final String newSuperiorDN;

    public TextFormattedModifyDNRequestAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedModifyDNRequestAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.deleteOldRDN = this.getBooleanNoThrow(TextFormattedAccessLogFields.MODDN_DELETE_OLD_RDN);
        this.newSuperiorDN = this.getString(TextFormattedAccessLogFields.MODDN_NEW_SUPERIOR_DN);
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.MODDN;
    }

    @Override
    @Nullable
    public final String getDN() {
        return this.dn;
    }

    @Override
    @Nullable
    public final String getNewRDN() {
        return this.newRDN;
    }

    @Override
    @Nullable
    public final Boolean getDeleteOldRDN() {
        return this.deleteOldRDN;
    }

    @Override
    @Nullable
    public final String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }
}

