/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class TinyIntColumnDef
extends AbstractColumnDef {
    private TinyIntColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, null);
    }

    public static Builder newTinyIntColumnDefBuilder() {
        return new Builder();
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "postgresql": {
                return "SMALLINT";
            }
            case "oracle": {
                return "NUMBER(3)";
            }
            case "mysql": {
                return "TINYINT(2)";
            }
            case "mssql": 
            case "h2": {
                return "TINYINT";
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown dialect '%s'", dialect.getId()));
    }

    public static class Builder {
        @CheckForNull
        private String columnName;
        private boolean isNullable = true;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public TinyIntColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new TinyIntColumnDef(this);
        }
    }
}

