/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.Validations;

public class DropIndexBuilder {
    private final Dialect dialect;
    private String tableName;
    private String indexName;

    public DropIndexBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public DropIndexBuilder setTable(String s) {
        this.tableName = s;
        return this;
    }

    public DropIndexBuilder setName(String s) {
        this.indexName = s;
        return this;
    }

    public List<String> build() {
        Validations.validateTableName(this.tableName);
        Validations.validateIndexName(this.indexName);
        return Collections.singletonList(this.createSqlStatement());
    }

    private String createSqlStatement() {
        switch (this.dialect.getId()) {
            case "mssql": 
            case "mysql": {
                return "DROP INDEX " + this.indexName + " ON " + this.tableName;
            }
            case "oracle": {
                return "DROP INDEX " + this.indexName;
            }
            case "h2": 
            case "postgresql": {
                return "DROP INDEX IF EXISTS " + this.indexName;
            }
        }
        throw new IllegalStateException("Unsupported dialect for drop of index: " + this.dialect);
    }

    public boolean indexExists(Database database) throws SQLException {
        Validations.validateTableName(this.tableName);
        Validations.validateIndexName(this.indexName);
        try (Connection connection = database.getDataSource().getConnection();){
            boolean bl = DatabaseUtils.indexExists((String)this.tableName, (String)this.indexName, (Connection)connection);
            return bl;
        }
    }
}

