/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.AlterColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class MakeComponentUuidAndAnalysisUuidNotNullOnDuplicationsIndex
extends DdlChange {
    private static final String TABLE_DUPLICATIONS_INDEX = "duplications_index";

    public MakeComponentUuidAndAnalysisUuidNotNullOnDuplicationsIndex(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        VarcharColumnDef analysisUuid = MakeComponentUuidAndAnalysisUuidNotNullOnDuplicationsIndex.newUuidColumn("analysis_uuid");
        VarcharColumnDef componentUuid = MakeComponentUuidAndAnalysisUuidNotNullOnDuplicationsIndex.newUuidColumn("component_uuid");
        context.execute(new AlterColumnsBuilder(this.getDatabase().getDialect(), TABLE_DUPLICATIONS_INDEX).updateColumn(componentUuid).updateColumn(analysisUuid).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_DUPLICATIONS_INDEX).setName("duplication_analysis_component").addColumn(analysisUuid).addColumn(componentUuid).build());
    }

    private static VarcharColumnDef newUuidColumn(String columnName) {
        return VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName(columnName).setLimit(50).setIsNullable(false).setIgnoreOracleUnit(true).build();
    }
}

