/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import java.sql.SQLException;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateSubscriptionOnOrganizations
extends DataChange {
    private final System2 system2;
    private final Configuration configuration;

    public PopulateSubscriptionOnOrganizations(Database db, System2 system2, Configuration configuration) {
        super(db);
        this.system2 = system2;
        this.configuration = configuration;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        if (this.configuration.getBoolean("sonar.sonarcloud.enabled").orElse(false).booleanValue()) {
            this.executeOnSonarCloud(context);
        } else {
            this.executeOnSonarQube(context);
        }
    }

    private void executeOnSonarQube(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("organizations");
        massUpdate.select("SELECT o.uuid FROM organizations o WHERE o.subscription IS NULL ");
        massUpdate.update("UPDATE organizations SET subscription=?, updated_at=? WHERE uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String uuid = row.getString(1);
            update.setString(1, "SONARQUBE");
            update.setLong(2, now);
            update.setString(3, uuid);
            return true;
        });
    }

    private void executeOnSonarCloud(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("organizations");
        massUpdate.select("SELECT o.uuid, count(p.uuid) FROM organizations o LEFT OUTER JOIN projects p on p.organization_uuid=o.uuid AND p.private=? WHERE subscription IS NULL GROUP BY o.uuid").setBoolean(1, true);
        massUpdate.update("UPDATE organizations SET subscription=?, updated_at=? WHERE uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String uuid = row.getString(1);
            long privateProjectsCount = row.getLong(2);
            update.setString(1, privateProjectsCount > 0L ? "PAID" : "FREE");
            update.setLong(2, now);
            update.setString(3, uuid);
            return true;
        });
    }
}

