/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v78;

import com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.Map;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.es.MigrationEsClient;
import org.sonar.server.platform.db.migration.step.DdlChange;

@SupportsBlueGreen
public class AddSecurityFieldsToElasticsearchIndices
extends DdlChange {
    private static final String ISSUE_INDEX = "issues";
    private static final String RULE_INDEX = "rules";
    private static final String KEYWORD_TYPE = "keyword";
    private final MigrationEsClient migrationEsClient;

    public AddSecurityFieldsToElasticsearchIndices(Database db, MigrationEsClient migrationEsClient) {
        super(db);
        this.migrationEsClient = migrationEsClient;
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        ImmutableMap mappingOptions = ImmutableMap.of((Object)"norms", (Object)"false");
        this.migrationEsClient.addMappingToExistingIndex(ISSUE_INDEX, "auth", "sonarsourceSecurity", KEYWORD_TYPE, (Map<String, String>)mappingOptions);
        this.migrationEsClient.addMappingToExistingIndex(RULE_INDEX, "rule", "cwe", KEYWORD_TYPE, (Map<String, String>)mappingOptions);
        this.migrationEsClient.addMappingToExistingIndex(RULE_INDEX, "rule", "owaspTop10", KEYWORD_TYPE, (Map<String, String>)mappingOptions);
        this.migrationEsClient.addMappingToExistingIndex(RULE_INDEX, "rule", "sansTop25", KEYWORD_TYPE, (Map<String, String>)mappingOptions);
        this.migrationEsClient.addMappingToExistingIndex(RULE_INDEX, "rule", "sonarsourceSecurity", KEYWORD_TYPE, (Map<String, String>)mappingOptions);
    }
}

