/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.NonUniqueHashIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDelegateIndex;
import org.h2.index.ScanIndex;
import org.h2.index.SpatialTreeIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class RegularTable
extends TableBase {
    private Index scanIndex;
    private long rowCount;
    private volatile Session lockExclusive;
    private HashSet<Session> lockShared = New.hashSet();
    private final Trace traceLock;
    private final ArrayList<Index> indexes = New.arrayList();
    private long lastModificationId;
    private boolean containsLargeObject;
    private final PageDataIndex mainIndex;
    private int changesSinceAnalyze;
    private int nextAnalyze;
    private Column rowIdColumn;
    private boolean waitForLock;

    public RegularTable(CreateTableData createTableData) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.isHidden = createTableData.isHidden;
        for (Column column : this.getColumns()) {
            if (!DataType.isLargeObject(column.getType())) continue;
            this.containsLargeObject = true;
        }
        if (createTableData.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData), createTableData.create, createTableData.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.mainIndex = null;
            this.scanIndex = new ScanIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData));
        }
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace("lock");
    }

    @Override
    public void close(Session session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.scanIndex.getRow(session, l);
    }

    @Override
    public void addRow(Session session, Row row) {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session.getId());
        }
        try {
            int n2 = this.indexes.size();
            for (n = 0; n < n2; ++n) {
                Index index = this.indexes.get(n);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            Object object;
            try {
                while (--n >= 0) {
                    object = this.indexes.get(n);
                    object.remove(session, row);
                    this.checkRowCount(session, (Index)object, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            object = DbException.convert(throwable);
            if (((DbException)object).getErrorCode() == 23505) {
                for (int i = 0; i < this.indexes.size(); ++i) {
                    MultiVersionIndex multiVersionIndex;
                    Index index = this.indexes.get(i);
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(multiVersionIndex = (MultiVersionIndex)index).isUncommittedFromOtherSession(session, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw object;
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void commit(short s, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        int n = this.indexes.size();
        for (int i = 0; i < n; ++i) {
            Index index = this.indexes.get(i);
            index.commit(s, row);
        }
    }

    private void checkRowCount(Session session, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && !(index instanceof PageDelegateIndex) && (l = index.getRowCount(session)) != this.rowCount + (long)n) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        Index index;
        boolean bl2;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int n2 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session) != 0L ? -1 : this.getMainIndexColumn(indexType, indexColumnArray));
            if (n2 != -1) {
                this.mainIndex.setMainIndexColumn(n2);
                index = new PageDelegateIndex(this, n, string, indexType, this.mainIndex, bl, session);
            } else {
                index = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string, indexColumnArray, indexType, true, bl, session) : new PageBtreeIndex(this, n, string, indexColumnArray, indexType, bl, session);
            }
        } else if (indexType.isHash()) {
            if (indexColumnArray.length != 1) {
                throw DbException.getUnsupportedException("hash indexes may index only one column");
            }
            index = indexType.isUnique() ? new HashIndex(this, n, string, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n, string, indexColumnArray, indexType);
        } else {
            index = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string, indexColumnArray, indexType, false, true, session) : new TreeIndex(this, n, string, indexColumnArray, indexType);
        }
        if (this.database.isMultiVersion()) {
            index = new MultiVersionIndex(index, this);
        }
        if (index.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                Index index2 = this.getScanIndex(session);
                long l2 = l = index2.getRowCount(session);
                Cursor cursor = index2.find(session, null, null);
                long l3 = 0L;
                int n3 = (int)Math.min(this.rowCount, 10000L);
                ArrayList<Row> arrayList = New.arrayList(n3);
                String string3 = this.getName() + ":" + index.getName();
                int n4 = MathUtils.convertLongToInt(l2);
                while (cursor.next()) {
                    this.database.setProgress(1, string3, MathUtils.convertLongToInt(l3++), n4);
                    Row row = cursor.get();
                    arrayList.add(row);
                    if (arrayList.size() >= n3) {
                        RegularTable.addRowsToIndex(session, arrayList, index);
                    }
                    --l;
                }
                RegularTable.addRowsToIndex(session, arrayList, index);
                if (SysProperties.CHECK && l != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (DbException dbException) {
                this.getSchema().freeUniqueName(string);
                try {
                    index.remove(session);
                }
                catch (DbException dbException2) {
                    this.trace.error(dbException2, "could not remove index");
                    throw dbException2;
                }
                throw dbException;
            }
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(string2);
            if (bl2) {
                session.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.mainIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    private static void addRowsToIndex(Session session, ArrayList<Row> arrayList, Index index) {
        final Index index2 = index;
        Collections.sort(arrayList, new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return index2.compareRows(row, row2);
            }
        });
        for (Row row : arrayList) {
            index.add(session, row);
        }
        arrayList.clear();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session, Row row) {
        int n;
        if (this.database.isMultiVersion()) {
            if (row.isDeleted()) {
                throw DbException.get(90131, this.getName());
            }
            n = row.getSessionId();
            int n2 = session.getId();
            if (n == 0) {
                row.setSessionId(n2);
            } else if (n != n2) {
                throw DbException.get(90131, this.getName());
            }
        }
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = this.indexes.get(n);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (++n < this.indexes.size()) {
                    Index index = this.indexes.get(n);
                    index.add(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        this.rowCount = 0L;
        this.changesSinceAnalyze = 0;
    }

    private void analyzeIfRequired(Session session) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        int n2 = session.getDatabase().getSettings().analyzeSample / 10;
        Analyze.analyzeTable(session, this, n2, false);
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusive == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusive == null) {
                return;
            }
        }
        if (this.lockExclusive == session) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            try {
                this.doLock(session, n, bl);
            }
            finally {
                session.setWaitForLock(null, null);
            }
        }
    }

    private void doLock(Session session, int n, boolean bl) {
        this.traceLock(session, bl, "requesting for");
        long l = 0L;
        boolean bl2 = false;
        while (this.lockExclusive != session) {
            if (bl) {
                if (this.lockExclusive == null) {
                    if (this.lockShared.isEmpty()) {
                        this.traceLock(session, bl, "added for");
                        session.addLock(this);
                        this.lockExclusive = session;
                        return;
                    }
                    if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                        this.traceLock(session, bl, "add (upgraded) for ");
                        this.lockExclusive = session;
                        return;
                    }
                }
            } else if (this.lockExclusive == null) {
                if (n == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                    return;
                }
                if (!this.lockShared.contains(session)) {
                    this.traceLock(session, bl, "ok");
                    session.addLock(this);
                    this.lockShared.add(session);
                }
                return;
            }
            session.setWaitForLock(this, Thread.currentThread());
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, RegularTable.getDeadlockDetails(arrayList));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.currentTimeMillis();
            if (l == 0L) {
                l = l2 + (long)session.getLockTimeout();
            } else if (l2 >= l) {
                this.traceLock(session, bl, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, l - l2)) == 0L) {
                    l3 = 1L;
                }
                this.waitForLock = true;
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private static String getDeadlockDetails(ArrayList<Session> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : arrayList) {
            Table table = session.getWaitForLock();
            Thread thread = session.getWaitForLockThread();
            stringBuilder.append("\nSession ").append(session.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(table.toString()).append(" while locking ");
            int n = 0;
            for (Table table2 : session.getLocks()) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof RegularTable)) continue;
                if (((RegularTable)table2).lockExclusive == session) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        Class<RegularTable> clazz = RegularTable.class;
        synchronized (RegularTable.class) {
            if (session2 == null) {
                session2 = session;
                set = New.hashSet();
            } else {
                if (session2 == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (set.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session);
            ArrayList<Session> arrayList = null;
            Object object = this.lockShared.iterator();
            while (object.hasNext()) {
                Table table;
                Session session3 = object.next();
                if (session3 == session || (table = session3.getWaitForLock()) == null || (arrayList = table.checkDeadlock(session3, session2, set)) == null) continue;
                arrayList.add(session);
                break;
            }
            if (arrayList == null && this.lockExclusive != null && (object = this.lockExclusive.getWaitForLock()) != null && (arrayList = ((Table)object).checkDeadlock(this.lockExclusive, session2, set)) != null) {
                arrayList.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayList;
        }
    }

    private void traceLock(Session session, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session.getId(), bl ? "exclusive write lock" : "shared read lock", string, this.getName());
        }
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session) {
        if (this.database != null) {
            this.traceLock(session, this.lockExclusive == session, "unlock");
            if (this.lockExclusive == session) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(session);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1 && this.waitForLock) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public static Row createRow(Value[] valueArray) {
        return new Row(valueArray, -1);
    }

    public void setRowCount(long l) {
        this.rowCount = l;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> arrayList;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (arrayList = this.getConstraints()) != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ConstraintReferential constraintReferential;
                Constraint constraint = arrayList.get(i);
                if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.scanIndex.getDiskSpaceUsed();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
        }
        return this.rowIdColumn;
    }
}

