/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="LinkToImageCheck")
public class LinkToImageCheck
extends AbstractPageCheck {
    private static final ImmutableSet<String> IMG_SUFFIXES = ImmutableSet.of(".GIF", ".JPG", ".JPEG", ".PNG", ".BMP");

    @Override
    public void startElement(TagNode node) {
        if (LinkToImageCheck.isATag(node) && LinkToImageCheck.hasHrefToImage(node)) {
            this.createViolation(node.getStartLinePosition(), "Change this link to not directly target an image.");
        }
    }

    private static boolean isATag(TagNode node) {
        return "A".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasHrefToImage(TagNode node) {
        String href = node.getAttribute("href");
        return href != null && LinkToImageCheck.isPoitingToAnImage(href);
    }

    private static boolean isPoitingToAnImage(String target) {
        String upperTarget = target.toUpperCase(Locale.ENGLISH);
        return Iterables.any(IMG_SUFFIXES, input -> input != null && upperTarget.endsWith((String)input));
    }
}

