/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="UnsupportedTagsInHtml5Check")
public class UnsupportedTagsInHtml5Check
extends AbstractPageCheck {
    private static final Set<String> UNSUPPORTED_TAGS = ImmutableSet.of("ACRONYM", "APPLET", "BASEFONT", "BGSOUND", "BIG", "BLINK", new String[]{"CENTER", "DIR", "FONT", "FRAME", "FRAMESET", "HGROUP", "ISINDEX", "LISTING", "MARQUEE", "MULTICOL", "NEXTID", "NOBR", "NOEMBED", "NOFRAMES", "PLAINTEXT", "SPACER", "STRIKE", "TT", "XMP"});

    @Override
    public void startElement(TagNode node) {
        if (UnsupportedTagsInHtml5Check.isUnsupportedTag(node)) {
            this.createViolation(node.getStartLinePosition(), "Remove this deprecated \"" + node.getNodeName() + "\" element.");
        }
    }

    private static boolean isUnsupportedTag(TagNode node) {
        String nodeName = node.getNodeName();
        return UNSUPPORTED_TAGS.contains(nodeName.toUpperCase(Locale.ENGLISH));
    }
}

