/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapSearch;

public class LdapGroupMapping {
    private static final Logger LOG = Loggers.get(LdapGroupMapping.class);
    private static final String DEFAULT_OBJECT_CLASS = "groupOfUniqueNames";
    private static final String DEFAULT_ID_ATTRIBUTE = "cn";
    private static final String DEFAULT_MEMBER_ATTRIBUTE = "uniqueMember";
    private static final String DEFAULT_REQUEST = "(&(objectClass=groupOfUniqueNames)(uniqueMember={dn}))";
    private final String baseDn;
    private final String idAttribute;
    private final String request;
    private final String[] requiredUserAttributes;

    public LdapGroupMapping(Settings settings, String settingsPrefix) {
        String req;
        this.baseDn = settings.getString(settingsPrefix + ".group.baseDn");
        this.idAttribute = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".group.idAttribute"), (String)DEFAULT_ID_ATTRIBUTE);
        String objectClass = settings.getString(settingsPrefix + ".group.objectClass");
        String memberAttribute = settings.getString(settingsPrefix + ".group.memberAttribute");
        if (StringUtils.isNotBlank((String)objectClass) || StringUtils.isNotBlank((String)memberAttribute)) {
            objectClass = StringUtils.defaultString((String)objectClass, (String)DEFAULT_OBJECT_CLASS);
            memberAttribute = StringUtils.defaultString((String)memberAttribute, (String)DEFAULT_MEMBER_ATTRIBUTE);
            req = "(&(objectClass=" + objectClass + ")(" + memberAttribute + "={dn}))";
            LOG.warn("Properties '" + settingsPrefix + ".group.objectClass' and '" + settingsPrefix + ".group.memberAttribute' are deprecated and should be replaced by single property '" + settingsPrefix + ".group.request' with value: " + req);
        } else {
            req = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".group.request"), (String)DEFAULT_REQUEST);
        }
        this.requiredUserAttributes = StringUtils.substringsBetween((String)req, (String)"{", (String)"}");
        for (int i = 0; i < this.requiredUserAttributes.length; ++i) {
            req = StringUtils.replace((String)req, (String)("{" + this.requiredUserAttributes[i] + "}"), (String)("{" + i + "}"));
        }
        this.request = req;
    }

    public LdapSearch createSearch(LdapContextFactory contextFactory, SearchResult user) {
        String[] attrs = this.getRequiredUserAttributes();
        String[] parameters = new String[attrs.length];
        for (int i = 0; i < parameters.length; ++i) {
            String attr = attrs[i];
            parameters[i] = "dn".equals(attr) ? user.getNameInNamespace() : LdapGroupMapping.getAttributeValue(user, attr);
        }
        return new LdapSearch(contextFactory).setBaseDn(this.getBaseDn()).setRequest(this.getRequest()).setParameters(parameters).returns(this.getIdAttribute());
    }

    private static String getAttributeValue(SearchResult user, String attributeId) {
        Attribute attribute = user.getAttributes().get(attributeId);
        if (attribute == null) {
            return null;
        }
        try {
            return (String)attribute.get();
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public String getIdAttribute() {
        return this.idAttribute;
    }

    public String getRequest() {
        return this.request;
    }

    public String[] getRequiredUserAttributes() {
        return this.requiredUserAttributes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{baseDn=" + this.getBaseDn() + ", idAttribute=" + this.getIdAttribute() + ", requiredUserAttributes=" + Arrays.toString(this.getRequiredUserAttributes()) + ", request=" + this.getRequest() + "}";
    }
}

