/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.Credentials;
import org.sonar.server.authentication.CredentialsAuthentication;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.usertoken.UserTokenAuthentication;

public class BasicAuthentication {
    private final DbClient dbClient;
    private final CredentialsAuthentication credentialsAuthentication;
    private final UserTokenAuthentication userTokenAuthentication;
    private final AuthenticationEvent authenticationEvent;

    public BasicAuthentication(DbClient dbClient, CredentialsAuthentication credentialsAuthentication, UserTokenAuthentication userTokenAuthentication, AuthenticationEvent authenticationEvent) {
        this.dbClient = dbClient;
        this.credentialsAuthentication = credentialsAuthentication;
        this.userTokenAuthentication = userTokenAuthentication;
        this.authenticationEvent = authenticationEvent;
    }

    public Optional<UserDto> authenticate(HttpServletRequest request) {
        return BasicAuthentication.extractCredentialsFromHeader(request).flatMap(credentials -> Optional.of(this.authenticate((Credentials)credentials, request)));
    }

    public static Optional<Credentials> extractCredentialsFromHeader(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader == null || !StringUtils.startsWithIgnoreCase((String)authorizationHeader, (String)"BASIC")) {
            return Optional.empty();
        }
        String basicAuthEncoded = authorizationHeader.substring(6);
        String basicAuthDecoded = BasicAuthentication.getDecodedBasicAuth(basicAuthEncoded);
        int semiColonPos = basicAuthDecoded.indexOf(58);
        if (semiColonPos <= 0) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC)).setMessage("Decoded basic auth does not contain ':'").build();
        }
        String login = basicAuthDecoded.substring(0, semiColonPos);
        String password = basicAuthDecoded.substring(semiColonPos + 1);
        return Optional.of(new Credentials(login, password));
    }

    private static String getDecodedBasicAuth(String basicAuthEncoded) {
        try {
            return new String(Base64.getDecoder().decode(basicAuthEncoded.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC)).setMessage("Invalid basic header").build();
        }
    }

    private UserDto authenticate(Credentials credentials, HttpServletRequest request) {
        if (!credentials.getPassword().isPresent()) {
            UserDto userDto = this.authenticateFromUserToken(credentials.getLogin());
            this.authenticationEvent.loginSuccess(request, userDto.getLogin(), AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC_TOKEN));
            return userDto;
        }
        return this.credentialsAuthentication.authenticate(credentials, request, AuthenticationEvent.Method.BASIC);
    }

    private UserDto authenticateFromUserToken(String token) {
        Optional<String> authenticatedUserUuid = this.userTokenAuthentication.authenticate(token);
        if (!authenticatedUserUuid.isPresent()) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC_TOKEN)).setMessage("Token doesn't exist").build();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.dbClient.userDao().selectByUuid(dbSession, authenticatedUserUuid.get());
            if (userDto == null || !userDto.isActive()) {
                throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC_TOKEN)).setMessage("User doesn't exist").build();
            }
            UserDto userDto2 = userDto;
            return userDto2;
        }
    }
}

