/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.queue.CeQueue;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.SystemPasscode;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class InfoAction
implements CeWsAction {
    private final UserSession userSession;
    private final SystemPasscode systemPasscode;
    private final CeQueue ceQueue;

    public InfoAction(UserSession userSession, SystemPasscode systemPasscode, CeQueue ceQueue) {
        this.userSession = userSession;
        this.systemPasscode = systemPasscode;
        this.ceQueue = ceQueue;
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction("info").setDescription("Gets information about Compute Engine. Requires the system administration permission or system passcode (see sonar.web.systemPasscode in sonar.properties).").setSince("7.2").setInternal(true).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("info-example.json"));
    }

    public void handle(Request request, Response response) throws Exception {
        if (!this.systemPasscode.isValid(request) && !this.userSession.isSystemAdministrator()) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        Ce.InfoWsResponse.Builder builder = Ce.InfoWsResponse.newBuilder();
        CeQueue.WorkersPauseStatus status = this.ceQueue.getWorkersPauseStatus();
        builder.setWorkersPauseStatus(this.convert(status));
        WsUtils.writeProtobuf((Message)builder.build(), request, response);
    }

    private Ce.WorkersPauseStatus convert(CeQueue.WorkersPauseStatus status) {
        switch (status) {
            case PAUSING: {
                return Ce.WorkersPauseStatus.PAUSING;
            }
            case PAUSED: {
                return Ce.WorkersPauseStatus.PAUSED;
            }
            case RESUMED: {
                return Ce.WorkersPauseStatus.RESUMED;
            }
        }
        throw new IllegalStateException("Unsupported WorkersPauseStatus: " + status);
    }
}

