/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.ProjectMeasuresIndexerIterator;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.component.ws.FilterParser;
import org.sonar.server.component.ws.ProjectMeasuresQueryFactory;
import org.sonar.server.component.ws.ProjectMeasuresQueryValidator;
import org.sonar.server.es.Facets;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.measure.index.ProjectMeasuresIndex;
import org.sonar.server.measure.index.ProjectMeasuresQuery;
import org.sonar.server.project.Visibility;
import org.sonar.server.qualitygate.ProjectsInWarning;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Components;

public class SearchProjectsAction
implements ComponentsWsAction {
    public static final int MAX_PAGE_SIZE = 500;
    public static final int DEFAULT_PAGE_SIZE = 100;
    private static final String ALL = "_all";
    private static final String ORGANIZATIONS = "organizations";
    private static final String ANALYSIS_DATE = "analysisDate";
    private static final String LEAK_PERIOD_DATE = "leakPeriodDate";
    private static final Set<String> POSSIBLE_FIELDS = Sets.newHashSet((Object[])new String[]{"_all", "organizations", "analysisDate", "leakPeriodDate"});
    private final DbClient dbClient;
    private final ProjectMeasuresIndex index;
    private final UserSession userSession;
    private final ProjectsInWarning projectsInWarning;

    public SearchProjectsAction(DbClient dbClient, ProjectMeasuresIndex index, UserSession userSession, ProjectsInWarning projectsInWarning) {
        this.dbClient = dbClient;
        this.index = index;
        this.userSession = userSession;
        this.projectsInWarning = projectsInWarning;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_projects").setSince("6.2").setDescription("Search for projects").addPagingParams(100, 500).setInternal(true).setResponseExample(this.getClass().getResource("search_projects-example.json")).setChangelog(new Change[]{new Change("6.4", String.format("The '%s' parameter accepts '%s' to filter by language", "languages", "filter")), new Change("6.4", "The 'visibility' field is added"), new Change("6.5", "The 'filter' parameter now allows 'NO_DATA' as value for numeric metrics"), new Change("6.5", "Added the option 'analysisDate' for the 'sort' parameter"), new Change("6.5", String.format("Value '%s' is added to parameter '%s'", LEAK_PERIOD_DATE, "f"))}).setHandler((RequestHandler)this);
        action.createFieldsParam(POSSIBLE_FIELDS).setDescription("Comma-separated list of the fields to be returned in response").setSince("6.4");
        action.createParam("organization").setDescription("the organization to search projects in").setRequired(false).setInternal(true).setSince("6.3");
        action.createParam("facets").setDescription("Comma-separated list of the facets to be computed. No facet is computed by default.").setPossibleValues((Collection)ProjectMeasuresIndex.SUPPORTED_FACETS.stream().sorted().collect(MoreCollectors.toList((int)ProjectMeasuresIndex.SUPPORTED_FACETS.size())));
        action.createParam("filter").setMinimumLength(Integer.valueOf(2)).setDescription("Filter of projects on name, key, measure value, quality gate, language, tag or whether a project is a favorite or not.<br>The filter must be encoded to form a valid URL (for example '=' must be replaced by '%3D').<br>Examples of use:<ul> <li>to filter my favorite projects with a failed quality gate and a coverage greater than or equals to 60% and a coverage strictly lower than 80%:<br>   <code>filter=\"alert_status = ERROR and isFavorite and coverage >= 60 and coverage < 80\"</code></li> <li>to filter projects with a reliability, security and maintainability rating equals or worse than B:<br>   <code>filter=\"reliability_rating>=2 and security_rating>=2 and sqale_rating>=2\"</code></li> <li>to filter projects without duplication data:<br>   <code>filter=\"duplicated_lines_density = NO_DATA\"</code></li></ul>To filter on project name or key, use the 'query' keyword, for instance : <code>filter='query = \"Sonar\"'</code>.<br><br>To filter on a numeric metric, provide the metric key.<br>These are the supported metric keys:<br><ul>" + ProjectMeasuresIndexerIterator.METRIC_KEYS.stream().sorted().map(key -> "<li>" + key + "</li>").collect(Collectors.joining()) + "</ul><br>To filter on a rating, provide the corresponding metric key (ex: reliability_rating for reliability rating).<br>The possible values are:<ul> <li>'1' for rating A</li> <li>'2' for rating B</li> <li>'3' for rating C</li> <li>'4' for rating D</li> <li>'5' for rating E</li></ul>To filter on a Quality Gate status use the metric key 'alert_status'. Only the '=' operator can be used.<br>The possible values are:<ul> <li>'OK' for Passed</li> <li>'WARN' for Warning</li> <li>'ERROR' for Failed</li></ul>To filter on language keys use the language key: <ul> <li>to filter on a single language you can use 'language = java'</li> <li>to filter on several languages you must use 'language IN (java, js)'</li></ul>Use the WS api/languages/list to find the key of a language.<br> To filter on tags use the 'tag' keyword:<ul>  <li>to filter on one tag you can use <code>tag = finance</code></li> <li>to filter on several tags you must use <code>tag in (offshore, java)</code></li></ul>");
        action.createParam("s").setDescription("Sort projects by numeric metric key, quality gate status (using '%s'), last analysis date (using '%s'), or by project name.", new Object[]{"alert_status", ANALYSIS_DATE, "filter"}).setDefaultValue((Object)"name").setPossibleValues((Collection)Stream.concat(ProjectMeasuresIndexerIterator.METRIC_KEYS.stream(), ProjectMeasuresQueryValidator.NON_METRIC_SORT_KEYS.stream()).sorted().collect(MoreCollectors.toList((int)(ProjectMeasuresIndexerIterator.METRIC_KEYS.size() + ProjectMeasuresQueryValidator.NON_METRIC_SORT_KEYS.size())))).setSince("6.4");
        action.createParam("asc").setDescription("Ascending sort").setBooleanPossibleValues().setDefaultValue((Object)true);
    }

    public void handle(Request httpRequest, Response httpResponse) throws Exception {
        Components.SearchProjectsWsResponse response = this.doHandle(SearchProjectsAction.toRequest(httpRequest));
        WsUtils.writeProtobuf((Message)response, httpRequest, httpResponse);
    }

    private Components.SearchProjectsWsResponse doHandle(SearchProjectsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String organizationKey = request.getOrganization();
            if (organizationKey == null) {
                Components.SearchProjectsWsResponse searchProjectsWsResponse = this.handleForAnyOrganization(dbSession, request);
                return searchProjectsWsResponse;
            }
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization for key '%s'", organizationKey);
            Components.SearchProjectsWsResponse searchProjectsWsResponse = this.handleForOrganization(dbSession, request, organization);
            return searchProjectsWsResponse;
        }
    }

    private Components.SearchProjectsWsResponse handleForAnyOrganization(DbSession dbSession, SearchProjectsRequest request) {
        SearchResults searchResults = this.searchData(dbSession, request, null);
        Set organizationUuids = (Set)searchResults.projects.stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet());
        Map organizationsByUuid = (Map)this.dbClient.organizationDao().selectByUuids(dbSession, organizationUuids).stream().collect(MoreCollectors.uniqueIndex(OrganizationDto::getUuid));
        return this.buildResponse(request, searchResults, organizationsByUuid);
    }

    private Components.SearchProjectsWsResponse handleForOrganization(DbSession dbSession, SearchProjectsRequest request, OrganizationDto organization) {
        SearchResults searchResults = this.searchData(dbSession, request, organization);
        return this.buildResponse(request, searchResults, (Map<String, OrganizationDto>)ImmutableMap.of((Object)organization.getUuid(), (Object)organization));
    }

    private SearchResults searchData(DbSession dbSession, SearchProjectsRequest request, @Nullable OrganizationDto organization) {
        List<FilterParser.Criterion> criteria;
        Set<String> favoriteProjectUuids = this.loadFavoriteProjectUuids(dbSession);
        ProjectMeasuresQuery query = ProjectMeasuresQueryFactory.newProjectMeasuresQuery(criteria, SearchProjectsAction.hasFavoriteFilter(criteria = FilterParser.parse((String)MoreObjects.firstNonNull((Object)request.getFilter(), (Object)""))) ? favoriteProjectUuids : null).setIgnoreWarning(this.projectsInWarning.count() == 0L).setSort(request.getSort()).setAsc(request.getAsc());
        Optional.ofNullable(organization).map(OrganizationDto::getUuid).ifPresent(query::setOrganizationUuid);
        ProjectMeasuresQueryValidator.validate(query);
        SearchIdResult<String> esResults = this.index.search(query, new SearchOptions().addFacets(request.getFacets()).setPage(request.getPage(), request.getPageSize()));
        List projectUuids = esResults.getIds();
        Ordering ordering = Ordering.explicit((List)projectUuids).onResultOf(ComponentDto::uuid);
        ImmutableList projects = ordering.immutableSortedCopy((Iterable)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)projectUuids));
        Map<String, SnapshotDto> analysisByProjectUuid = this.getSnapshots(dbSession, request, projectUuids);
        return new SearchResults((List)projects, favoriteProjectUuids, esResults, analysisByProjectUuid, query);
    }

    private static boolean hasFavoriteFilter(List<FilterParser.Criterion> criteria) {
        return criteria.stream().map(FilterParser.Criterion::getKey).anyMatch("isFavorite"::equalsIgnoreCase);
    }

    private Set<String> loadFavoriteProjectUuids(DbSession dbSession) {
        if (!this.userSession.isLoggedIn()) {
            return Collections.emptySet();
        }
        List props = this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setUserId(this.userSession.getUserId()).setKey("favourite").build(), dbSession);
        List favoriteDbIds = (List)props.stream().map(PropertyDto::getResourceId).collect(MoreCollectors.toList((int)props.size()));
        return (Set)this.dbClient.componentDao().selectByIds(dbSession, (Collection)favoriteDbIds).stream().filter(ComponentDto::isEnabled).filter(f -> f.qualifier().equals("TRK")).map(ComponentDto::uuid).collect(MoreCollectors.toSet());
    }

    private Map<String, SnapshotDto> getSnapshots(DbSession dbSession, SearchProjectsRequest request, List<String> projectUuids) {
        if (request.getAdditionalFields().contains(ANALYSIS_DATE) || request.getAdditionalFields().contains(LEAK_PERIOD_DATE)) {
            return (Map)this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, projectUuids).stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getComponentUuid));
        }
        return Collections.emptyMap();
    }

    private static SearchProjectsRequest toRequest(Request httpRequest) {
        RequestBuilder request = new RequestBuilder().setOrganization(httpRequest.param("organization")).setFilter(httpRequest.param("filter")).setSort(httpRequest.mandatoryParam("s")).setAsc(httpRequest.mandatoryParamAsBoolean("asc")).setPage(httpRequest.mandatoryParamAsInt("p")).setPageSize(httpRequest.mandatoryParamAsInt("ps"));
        if (httpRequest.hasParam("facets")) {
            request.setFacets(httpRequest.mandatoryParamAsStrings("facets"));
        }
        if (httpRequest.hasParam("f")) {
            List paramsAsString = httpRequest.mandatoryParamAsStrings("f");
            if (paramsAsString.contains(ALL)) {
                request.setAdditionalFields((List<String>)ImmutableList.of((Object)ORGANIZATIONS, (Object)ANALYSIS_DATE, (Object)LEAK_PERIOD_DATE));
            } else {
                request.setAdditionalFields(paramsAsString);
            }
        }
        return request.build();
    }

    private Components.SearchProjectsWsResponse buildResponse(SearchProjectsRequest request, SearchResults searchResults, Map<String, OrganizationDto> organizationsByUuid) {
        DbToWsComponent dbToWsComponent = new DbToWsComponent(request, organizationsByUuid, searchResults.favoriteProjectUuids, searchResults.analysisByProjectUuid, this.userSession.isLoggedIn());
        HashMap<String, OrganizationDto> organizationsByUuidForAdditionalInfo = new HashMap<String, OrganizationDto>();
        if (request.additionalFields.contains(ORGANIZATIONS)) {
            organizationsByUuidForAdditionalInfo.putAll(organizationsByUuid);
        }
        return Stream.of(Components.SearchProjectsWsResponse.newBuilder()).map(response -> response.setPaging(Common.Paging.newBuilder().setPageIndex(request.getPage()).setPageSize(request.getPageSize()).setTotal(searchResults.total))).map(response -> {
            searchResults.projects.stream().map(dbToWsComponent).forEach(arg_0 -> ((Components.SearchProjectsWsResponse.Builder)response).addComponents(arg_0));
            return response;
        }).map(response -> {
            organizationsByUuidForAdditionalInfo.values().stream().forEach(dto -> response.addOrganizations(Common.Organization.newBuilder().setKey(dto.getKey()).setName(dto.getName()).build()));
            return response;
        }).map(response -> SearchProjectsAction.addFacets(searchResults, response)).map(Components.SearchProjectsWsResponse.Builder::build).findFirst().orElseThrow(() -> new IllegalStateException("SearchProjectsWsResponse not built"));
    }

    private static Components.SearchProjectsWsResponse.Builder addFacets(SearchResults searchResults, Components.SearchProjectsWsResponse.Builder wsResponse) {
        Facets esFacets = searchResults.facets;
        EsToWsFacet esToWsFacet = new EsToWsFacet();
        searchResults.query.getLanguages().ifPresent(languages -> SearchProjectsAction.addMandatoryValuesToFacet(esFacets, "languages", languages));
        searchResults.query.getTags().ifPresent(tags -> SearchProjectsAction.addMandatoryValuesToFacet(esFacets, "tags", tags));
        Common.Facets wsFacets = esFacets.getAll().entrySet().stream().map(esToWsFacet).collect(Collector.of(Common.Facets::newBuilder, Common.Facets.Builder::addFacets, (result1, result2) -> {
            throw new IllegalStateException("Parallel execution forbidden");
        }, Common.Facets.Builder::build, new Collector.Characteristics[0]));
        wsResponse.setFacets(wsFacets);
        return wsResponse;
    }

    private static void addMandatoryValuesToFacet(Facets facets, String facetName, Iterable<String> mandatoryValues) {
        LinkedHashMap buckets = facets.get(facetName);
        if (buckets == null) {
            return;
        }
        for (String mandatoryValue : mandatoryValues) {
            if (buckets.containsKey(mandatoryValue)) continue;
            buckets.put(mandatoryValue, 0L);
        }
    }

    static class RequestBuilder {
        private String organization;
        private Integer page;
        private Integer pageSize;
        private String filter;
        private List<String> facets = new ArrayList<String>();
        private String sort;
        private Boolean asc;
        private List<String> additionalFields = new ArrayList<String>();

        private RequestBuilder() {
        }

        public RequestBuilder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public RequestBuilder setFilter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public RequestBuilder setFacets(List<String> facets) {
            this.facets = Objects.requireNonNull(facets);
            return this;
        }

        public RequestBuilder setPage(int page) {
            this.page = page;
            return this;
        }

        public RequestBuilder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public RequestBuilder setSort(@Nullable String sort) {
            this.sort = sort;
            return this;
        }

        public RequestBuilder setAsc(boolean asc) {
            this.asc = asc;
            return this;
        }

        public RequestBuilder setAdditionalFields(List<String> additionalFields) {
            this.additionalFields = Objects.requireNonNull(additionalFields, "additional fields cannot be null");
            return this;
        }

        public SearchProjectsRequest build() {
            if (this.page == null) {
                this.page = 1;
            }
            if (this.pageSize == null) {
                this.pageSize = 100;
            }
            Preconditions.checkArgument((this.pageSize <= 500 ? 1 : 0) != 0, (String)"Page size must not be greater than %s", (Object[])new Object[]{500});
            return new SearchProjectsRequest(this);
        }
    }

    static class SearchProjectsRequest {
        private final int page;
        private final int pageSize;
        private final String organization;
        private final String filter;
        private final List<String> facets;
        private final String sort;
        private final Boolean asc;
        private final List<String> additionalFields;

        private SearchProjectsRequest(RequestBuilder builder) {
            this.page = builder.page;
            this.pageSize = builder.pageSize;
            this.organization = builder.organization;
            this.filter = builder.filter;
            this.facets = builder.facets;
            this.sort = builder.sort;
            this.asc = builder.asc;
            this.additionalFields = builder.additionalFields;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        @CheckForNull
        public String getFilter() {
            return this.filter;
        }

        public List<String> getFacets() {
            return this.facets;
        }

        @CheckForNull
        public String getSort() {
            return this.sort;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public int getPage() {
            return this.page;
        }

        @CheckForNull
        public Boolean getAsc() {
            return this.asc;
        }

        public List<String> getAdditionalFields() {
            return this.additionalFields;
        }

        public static RequestBuilder builder() {
            return new RequestBuilder();
        }
    }

    private static class SearchResults {
        private final List<ComponentDto> projects;
        private final Set<String> favoriteProjectUuids;
        private final Facets facets;
        private final Map<String, SnapshotDto> analysisByProjectUuid;
        private final ProjectMeasuresQuery query;
        private final int total;

        private SearchResults(List<ComponentDto> projects, Set<String> favoriteProjectUuids, SearchIdResult<String> searchResults, Map<String, SnapshotDto> analysisByProjectUuid, ProjectMeasuresQuery query) {
            this.projects = projects;
            this.favoriteProjectUuids = favoriteProjectUuids;
            this.total = (int)searchResults.getTotal();
            this.facets = searchResults.getFacets();
            this.analysisByProjectUuid = analysisByProjectUuid;
            this.query = query;
        }
    }

    private static class DbToWsComponent
    implements Function<ComponentDto, Components.Component> {
        private final SearchProjectsRequest request;
        private final Components.Component.Builder wsComponent;
        private final Map<String, OrganizationDto> organizationsByUuid;
        private final Set<String> favoriteProjectUuids;
        private final boolean isUserLoggedIn;
        private final Map<String, SnapshotDto> analysisByProjectUuid;

        private DbToWsComponent(SearchProjectsRequest request, Map<String, OrganizationDto> organizationsByUuid, Set<String> favoriteProjectUuids, Map<String, SnapshotDto> analysisByProjectUuid, boolean isUserLoggedIn) {
            this.request = request;
            this.analysisByProjectUuid = analysisByProjectUuid;
            this.wsComponent = Components.Component.newBuilder();
            this.organizationsByUuid = organizationsByUuid;
            this.favoriteProjectUuids = favoriteProjectUuids;
            this.isUserLoggedIn = isUserLoggedIn;
        }

        @Override
        public Components.Component apply(ComponentDto dbComponent) {
            String organizationUuid = dbComponent.getOrganizationUuid();
            OrganizationDto organizationDto = this.organizationsByUuid.get(organizationUuid);
            WsUtils.checkFound(organizationDto, "Organization with uuid '%s' not found", organizationUuid);
            this.wsComponent.clear().setOrganization(organizationDto.getKey()).setId(dbComponent.uuid()).setKey(dbComponent.getDbKey()).setName(dbComponent.name()).setVisibility(Visibility.getLabel(dbComponent.isPrivate()));
            this.wsComponent.getTagsBuilder().addAllTags((Iterable)dbComponent.getTags());
            SnapshotDto snapshotDto = this.analysisByProjectUuid.get(dbComponent.uuid());
            if (snapshotDto != null) {
                if (this.request.getAdditionalFields().contains(SearchProjectsAction.ANALYSIS_DATE)) {
                    this.wsComponent.setAnalysisDate(DateUtils.formatDateTime((long)snapshotDto.getCreatedAt()));
                }
                if (this.request.getAdditionalFields().contains(SearchProjectsAction.LEAK_PERIOD_DATE)) {
                    Optional.ofNullable(snapshotDto.getPeriodDate()).ifPresent(leakPeriodDate -> this.wsComponent.setLeakPeriodDate(DateUtils.formatDateTime((long)leakPeriodDate)));
                }
            }
            if (this.isUserLoggedIn) {
                this.wsComponent.setIsFavorite(this.favoriteProjectUuids.contains(dbComponent.uuid()));
            }
            return this.wsComponent.build();
        }
    }

    private static class BucketToFacetValue
    implements Function<Map.Entry<String, Long>, Common.FacetValue> {
        private final Common.FacetValue.Builder facetValue = Common.FacetValue.newBuilder();

        private BucketToFacetValue() {
        }

        @Override
        public Common.FacetValue apply(Map.Entry<String, Long> bucket) {
            return this.facetValue.clear().setVal(bucket.getKey()).setCount(bucket.getValue().longValue()).build();
        }
    }

    private static class EsToWsFacet
    implements Function<Map.Entry<String, LinkedHashMap<String, Long>>, Common.Facet> {
        private final BucketToFacetValue bucketToFacetValue = new BucketToFacetValue();
        private final Common.Facet.Builder wsFacet = Common.Facet.newBuilder();

        private EsToWsFacet() {
        }

        @Override
        public Common.Facet apply(Map.Entry<String, LinkedHashMap<String, Long>> esFacet) {
            this.wsFacet.clear().setProperty(esFacet.getKey());
            LinkedHashMap<String, Long> buckets = esFacet.getValue();
            if (buckets != null) {
                buckets.entrySet().stream().map(this.bucketToFacetValue).forEach(arg_0 -> ((Common.Facet.Builder)this.wsFacet).addValues(arg_0));
            } else {
                this.wsFacet.addAllValues(Collections.emptyList());
            }
            return this.wsFacet.build();
        }
    }
}

