/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.Maps;
import java.util.Map;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.newindex.BuiltIndex;
import org.sonar.server.es.newindex.NewIndex;

@ServerSide
public class IndexDefinitions
implements Startable {
    private final Map<String, BuiltIndex> byKey = Maps.newHashMap();
    private final IndexDefinition[] defs;
    private final Configuration config;

    public IndexDefinitions(IndexDefinition[] defs, Configuration config) {
        this.defs = defs;
        this.config = config;
    }

    public Map<String, BuiltIndex> getIndices() {
        return this.byKey;
    }

    public void start() {
        IndexDefinition.IndexDefinitionContext context = new IndexDefinition.IndexDefinitionContext();
        if (!this.config.getBoolean("sonar.internal.es.disableIndexes").orElse(false).booleanValue()) {
            for (IndexDefinition definition : this.defs) {
                definition.define(context);
            }
            for (Map.Entry entry : context.getIndices().entrySet()) {
                this.byKey.put((String)entry.getKey(), ((NewIndex)entry.getValue()).build());
            }
        }
    }

    public void stop() {
    }
}

