/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.es.EsClient;
import org.sonar.server.health.Health;

abstract class EsStatusCheck {
    private static final Logger LOG = Loggers.get(EsStatusCheck.class);
    private static final Health YELLOW_HEALTH = Health.newHealthCheckBuilder().setStatus(Health.Status.YELLOW).addCause("Elasticsearch status is YELLOW").build();
    private static final Health RED_HEALTH = Health.newHealthCheckBuilder().setStatus(Health.Status.RED).addCause("Elasticsearch status is RED").build();
    private static final Health RED_HEALTH_UNAVAILABLE = Health.newHealthCheckBuilder().setStatus(Health.Status.RED).addCause("Elasticsearch status is RED (unavailable)").build();
    private final EsClient esClient;

    EsStatusCheck(EsClient esClient) {
        this.esClient = esClient;
    }

    Health checkEsStatus() {
        try {
            ClusterHealthStatus esStatus = ((ClusterStatsResponse)this.esClient.prepareClusterStats().get()).getStatus();
            if (esStatus == null) {
                return RED_HEALTH_UNAVAILABLE;
            }
            switch (esStatus) {
                case GREEN: {
                    return Health.GREEN;
                }
                case YELLOW: {
                    return YELLOW_HEALTH;
                }
                case RED: {
                    return RED_HEALTH;
                }
            }
            throw new IllegalArgumentException("Unsupported Elasticsearch status " + esStatus);
        }
        catch (Exception e) {
            LOG.error("Failed to query ES status", (Throwable)e);
            return RED_HEALTH_UNAVAILABLE;
        }
    }
}

