/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.measure.ws.ComponentTreeData;
import org.sonar.server.measure.ws.ComponentTreeRequest;

public class ComponentTreeSort {
    private static final Set<Metric.ValueType> NUMERIC_VALUE_TYPES = EnumSet.of(Metric.ValueType.BOOL, new Metric.ValueType[]{Metric.ValueType.FLOAT, Metric.ValueType.INT, Metric.ValueType.MILLISEC, Metric.ValueType.WORK_DUR, Metric.ValueType.PERCENT, Metric.ValueType.RATING});
    private static final Set<Metric.ValueType> TEXTUAL_VALUE_TYPES = EnumSet.of(Metric.ValueType.STRING);

    private ComponentTreeSort() {
    }

    public static List<ComponentDto> sortComponents(List<ComponentDto> components, ComponentTreeRequest wsRequest, List<MetricDto> metrics, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        List<String> sortParameters = wsRequest.getSort();
        if (sortParameters == null || sortParameters.isEmpty()) {
            return components;
        }
        boolean isAscending = wsRequest.getAsc();
        ImmutableMap orderingsBySortField = ImmutableMap.builder().put((Object)"name", ComponentTreeSort.componentNameOrdering(isAscending)).put((Object)"qualifier", ComponentTreeSort.componentQualifierOrdering(isAscending)).put((Object)"path", ComponentTreeSort.componentPathOrdering(isAscending)).put((Object)"metric", ComponentTreeSort.metricValueOrdering(wsRequest, metrics, measuresByComponentUuidAndMetric)).put((Object)"metricPeriod", ComponentTreeSort.metricPeriodOrdering(wsRequest, metrics, measuresByComponentUuidAndMetric)).build();
        String firstSortParameter = sortParameters.get(0);
        Ordering primaryOrdering = (Ordering)orderingsBySortField.get(firstSortParameter);
        if (sortParameters.size() > 1) {
            for (int i = 1; i < sortParameters.size(); ++i) {
                String secondarySortParameter = sortParameters.get(i);
                Ordering secondaryOrdering = (Ordering)orderingsBySortField.get(secondarySortParameter);
                primaryOrdering = primaryOrdering.compound((Comparator)secondaryOrdering);
            }
        }
        primaryOrdering = primaryOrdering.compound(ComponentTreeSort.componentNameOrdering(true));
        return primaryOrdering.immutableSortedCopy(components);
    }

    private static Ordering<ComponentDto> componentNameOrdering(boolean isAscending) {
        return ComponentTreeSort.stringOrdering(isAscending, (Function<ComponentDto, String>)((Function)ComponentDto::name));
    }

    private static Ordering<ComponentDto> componentQualifierOrdering(boolean isAscending) {
        return ComponentTreeSort.stringOrdering(isAscending, (Function<ComponentDto, String>)((Function)ComponentDto::qualifier));
    }

    private static Ordering<ComponentDto> componentPathOrdering(boolean isAscending) {
        return ComponentTreeSort.stringOrdering(isAscending, (Function<ComponentDto, String>)((Function)ComponentDto::path));
    }

    private static Ordering<ComponentDto> stringOrdering(boolean isAscending, Function<ComponentDto, String> function) {
        Ordering ordering = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
        if (!isAscending) {
            ordering = ordering.reverse();
        }
        return ordering.nullsLast().onResultOf(function);
    }

    private static Ordering<ComponentDto> metricValueOrdering(ComponentTreeRequest wsRequest, List<MetricDto> metrics, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        if (wsRequest.getMetricSort() == null) {
            return ComponentTreeSort.componentNameOrdering(wsRequest.getAsc());
        }
        ImmutableMap metricsByKey = Maps.uniqueIndex(metrics, MetricDto::getKey);
        MetricDto metric = (MetricDto)metricsByKey.get(wsRequest.getMetricSort());
        boolean isAscending = wsRequest.getAsc();
        Metric.ValueType metricValueType = Metric.ValueType.valueOf((String)metric.getValueType());
        if (NUMERIC_VALUE_TYPES.contains(metricValueType)) {
            return ComponentTreeSort.numericalMetricOrdering(isAscending, metric, measuresByComponentUuidAndMetric);
        }
        if (TEXTUAL_VALUE_TYPES.contains(metricValueType)) {
            return ComponentTreeSort.stringOrdering(isAscending, new ComponentDtoToTextualMeasureValue(metric, measuresByComponentUuidAndMetric));
        }
        if (Metric.ValueType.LEVEL.equals((Object)Metric.ValueType.valueOf((String)metric.getValueType()))) {
            return ComponentTreeSort.levelMetricOrdering(isAscending, metric, measuresByComponentUuidAndMetric);
        }
        throw new IllegalStateException("Unrecognized metric value type: " + metric.getValueType());
    }

    private static Ordering<ComponentDto> metricPeriodOrdering(ComponentTreeRequest wsRequest, List<MetricDto> metrics, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        if (wsRequest.getMetricSort() == null || wsRequest.getMetricPeriodSort() == null) {
            return ComponentTreeSort.componentNameOrdering(wsRequest.getAsc());
        }
        ImmutableMap metricsByKey = Maps.uniqueIndex(metrics, MetricDto::getKey);
        MetricDto metric = (MetricDto)metricsByKey.get(wsRequest.getMetricSort());
        Metric.ValueType metricValueType = Metric.ValueType.valueOf((String)metric.getValueType());
        if (NUMERIC_VALUE_TYPES.contains(metricValueType)) {
            return ComponentTreeSort.numericalMetricPeriodOrdering(wsRequest, metric, measuresByComponentUuidAndMetric);
        }
        throw BadRequestException.create(String.format("Impossible to sort metric '%s' by measure period.", metric.getKey()));
    }

    private static Ordering<ComponentDto> numericalMetricOrdering(boolean isAscending, @Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        Ordering ordering = Ordering.natural();
        if (!isAscending) {
            ordering = ordering.reverse();
        }
        return ordering.nullsLast().onResultOf((Function)new ComponentDtoToNumericalMeasureValue(metric, measuresByComponentUuidAndMetric));
    }

    private static Ordering<ComponentDto> numericalMetricPeriodOrdering(ComponentTreeRequest request, @Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        Ordering ordering = Ordering.natural();
        if (!request.getAsc().booleanValue()) {
            ordering = ordering.reverse();
        }
        return ordering.nullsLast().onResultOf((Function)new ComponentDtoToMeasureVariationValue(metric, measuresByComponentUuidAndMetric));
    }

    private static Ordering<ComponentDto> levelMetricOrdering(boolean isAscending, @Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        Ordering ordering = Ordering.natural();
        if (isAscending) {
            ordering = ordering.reverse();
        }
        return ordering.nullsLast().onResultOf((Function)new ComponentDtoToLevelIndex(metric, measuresByComponentUuidAndMetric));
    }

    private static class ComponentDtoToTextualMeasureValue
    implements Function<ComponentDto, String> {
        private final MetricDto metric;
        private final Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric;

        private ComponentDtoToTextualMeasureValue(@Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
            this.metric = metric;
            this.measuresByComponentUuidAndMetric = measuresByComponentUuidAndMetric;
        }

        public String apply(@Nonnull ComponentDto input) {
            ComponentTreeData.Measure measure = (ComponentTreeData.Measure)this.measuresByComponentUuidAndMetric.get((Object)input.uuid(), (Object)this.metric);
            if (measure == null || measure.getData() == null) {
                return null;
            }
            return measure.getData();
        }
    }

    private static class ComponentDtoToMeasureVariationValue
    implements Function<ComponentDto, Double> {
        private final MetricDto metric;
        private final Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric;

        private ComponentDtoToMeasureVariationValue(@Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
            this.metric = metric;
            this.measuresByComponentUuidAndMetric = measuresByComponentUuidAndMetric;
        }

        public Double apply(@Nonnull ComponentDto input) {
            ComponentTreeData.Measure measure = (ComponentTreeData.Measure)this.measuresByComponentUuidAndMetric.get((Object)input.uuid(), (Object)this.metric);
            if (measure == null || !measure.isVariationSet()) {
                return null;
            }
            return measure.getVariation();
        }
    }

    private static class ComponentDtoToLevelIndex
    implements Function<ComponentDto, Integer> {
        private final MetricDto metric;
        private final Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric;

        private ComponentDtoToLevelIndex(@Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
            this.metric = metric;
            this.measuresByComponentUuidAndMetric = measuresByComponentUuidAndMetric;
        }

        public Integer apply(@Nonnull ComponentDto input) {
            ComponentTreeData.Measure measure = (ComponentTreeData.Measure)this.measuresByComponentUuidAndMetric.get((Object)input.uuid(), (Object)this.metric);
            if (measure == null || measure.getData() == null) {
                return null;
            }
            return Metric.Level.names().indexOf(measure.getData());
        }
    }

    private static class ComponentDtoToNumericalMeasureValue
    implements Function<ComponentDto, Double> {
        private final MetricDto metric;
        private final Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric;

        private ComponentDtoToNumericalMeasureValue(@Nullable MetricDto metric, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
            this.metric = metric;
            this.measuresByComponentUuidAndMetric = measuresByComponentUuidAndMetric;
        }

        public Double apply(@Nonnull ComponentDto input) {
            ComponentTreeData.Measure measure = (ComponentTreeData.Measure)this.measuresByComponentUuidAndMetric.get((Object)input.uuid(), (Object)this.metric);
            if (measure == null || !measure.isValueSet()) {
                return null;
            }
            return measure.getValue();
        }
    }
}

