/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.ws.WsUtils;

public abstract class PermissionChange {
    private final Operation operation;
    private final String organizationUuid;
    private final String permission;
    private final ProjectId projectId;
    protected final PermissionService permissionService;

    public PermissionChange(Operation operation, String organizationUuid, String permission, @Nullable ProjectId projectId, PermissionService permissionService) {
        this.operation = Objects.requireNonNull(operation);
        this.organizationUuid = Objects.requireNonNull(organizationUuid);
        this.permission = Objects.requireNonNull(permission);
        this.projectId = projectId;
        this.permissionService = permissionService;
        if (projectId == null) {
            WsUtils.checkRequest(permissionService.getAllOrganizationPermissions().stream().anyMatch(p -> p.getKey().equals(permission)), "Invalid global permission '%s'. Valid values are %s", permission, permissionService.getAllOrganizationPermissions().stream().map(OrganizationPermission::getKey).collect(MoreCollectors.toList()));
        } else {
            WsUtils.checkRequest(permissionService.getAllProjectPermissions().contains(permission), "Invalid project permission '%s'. Valid values are %s", permission, permissionService.getAllProjectPermissions());
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String getPermission() {
        return this.permission;
    }

    public Optional<ProjectId> getProjectId() {
        return Optional.ofNullable(this.projectId);
    }

    @CheckForNull
    public String getProjectUuid() {
        return this.projectId == null ? null : this.projectId.getUuid();
    }

    @CheckForNull
    public Long getNullableProjectId() {
        return this.projectId == null ? null : Long.valueOf(this.projectId.getId());
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }
}

