/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.Optional;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;

public class PermissionPrivilegeChecker {
    private PermissionPrivilegeChecker() {
    }

    public static void checkGlobalAdmin(UserSession userSession, String organizationUuid) {
        userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER, organizationUuid);
    }

    public static void checkProjectAdmin(UserSession userSession, String organizationUuid, Optional<ProjectId> projectId) {
        userSession.checkLoggedIn();
        if (userSession.hasPermission(OrganizationPermission.ADMINISTER, organizationUuid)) {
            return;
        }
        if (!projectId.isPresent()) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        userSession.checkComponentUuidPermission("admin", projectId.get().getUuid());
    }
}

