/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.permission.index.AuthorizationDoc;
import org.sonar.server.permission.index.AuthorizationScope;
import org.sonar.server.permission.index.IndexPermissions;
import org.sonar.server.permission.index.NeedAuthorizationIndexer;
import org.sonar.server.permission.index.PermissionIndexerDao;

public class PermissionIndexer
implements ProjectIndexer {
    private final DbClient dbClient;
    private final EsClient esClient;
    private final Collection<AuthorizationScope> authorizationScopes;
    private final Map<String, IndexType> indexTypeByFormat;

    public PermissionIndexer(DbClient dbClient, EsClient esClient, NeedAuthorizationIndexer ... needAuthorizationIndexers) {
        this(dbClient, esClient, (Collection)Arrays.stream(needAuthorizationIndexers).map(NeedAuthorizationIndexer::getAuthorizationScope).collect(MoreCollectors.toList((int)needAuthorizationIndexers.length)));
    }

    @VisibleForTesting
    public PermissionIndexer(DbClient dbClient, EsClient esClient, Collection<AuthorizationScope> authorizationScopes) {
        this.dbClient = dbClient;
        this.esClient = esClient;
        this.authorizationScopes = authorizationScopes;
        this.indexTypeByFormat = (Map)authorizationScopes.stream().map(AuthorizationScope::getIndexType).collect(MoreCollectors.uniqueIndex(IndexType.IndexMainType::format, t -> t, (int)authorizationScopes.size()));
    }

    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.copyOf(this.indexTypeByFormat.values());
    }

    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        List<IndexPermissions> authorizations = this.getAllAuthorizations();
        Stream<AuthorizationScope> scopes = this.getScopes(uninitializedIndexTypes);
        this.index(authorizations, scopes, BulkIndexer.Size.LARGE);
    }

    @VisibleForTesting
    void index(List<IndexPermissions> authorizations) {
        this.index(authorizations, this.authorizationScopes.stream(), BulkIndexer.Size.REGULAR);
    }

    public void indexOnAnalysis(String branchUuid) {
    }

    public Collection<EsQueueDto> prepareForRecovery(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        switch (cause) {
            case MEASURE_CHANGE: 
            case PROJECT_KEY_UPDATE: 
            case PROJECT_TAGS_UPDATE: {
                return Collections.emptyList();
            }
            case PROJECT_CREATION: 
            case PROJECT_DELETION: 
            case PERMISSION_CHANGE: {
                return this.insertIntoEsQueue(dbSession, projectUuids);
            }
        }
        throw new IllegalStateException("Unsupported cause: " + cause);
    }

    private Collection<EsQueueDto> insertIntoEsQueue(DbSession dbSession, Collection<String> projectUuids) {
        List items = (List)this.indexTypeByFormat.values().stream().flatMap(indexType -> projectUuids.stream().map(projectUuid -> EsQueueDto.create((String)indexType.format(), (String)AuthorizationDoc.idOf((String)projectUuid), null, (String)projectUuid))).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        return items;
    }

    private void index(Collection<IndexPermissions> authorizations, Stream<AuthorizationScope> scopes, BulkIndexer.Size bulkSize) {
        if (authorizations.isEmpty()) {
            return;
        }
        scopes.forEach(scope -> {
            IndexType.IndexMainType indexType = scope.getIndexType();
            BulkIndexer bulkIndexer = new BulkIndexer(this.esClient, (IndexType)indexType, bulkSize);
            bulkIndexer.start();
            authorizations.stream().filter(scope.getProjectPredicate()).map(arg_0 -> PermissionIndexer.lambda$index$3((IndexType)indexType, arg_0)).forEach(arg_0 -> ((BulkIndexer)bulkIndexer).add(arg_0));
            bulkIndexer.stop();
        });
    }

    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        IndexingResult result = new IndexingResult();
        List<BulkIndexer> bulkIndexers = items.stream().map(EsQueueDto::getDocType).distinct().map(this.indexTypeByFormat::get).filter(Objects::nonNull).map(indexType -> new BulkIndexer(this.esClient, indexType, BulkIndexer.Size.REGULAR, (IndexingListener)new OneToOneResilientIndexingListener(this.dbClient, dbSession, items))).collect(Collectors.toList());
        if (bulkIndexers.isEmpty()) {
            return result;
        }
        bulkIndexers.forEach(BulkIndexer::start);
        PermissionIndexerDao permissionIndexerDao = new PermissionIndexerDao();
        Set remainingProjectUuids = (Set)items.stream().map(EsQueueDto::getDocId).map(AuthorizationDoc::projectUuidOf).collect(MoreCollectors.toHashSet());
        permissionIndexerDao.selectByUuids(this.dbClient, dbSession, remainingProjectUuids).forEach(p -> {
            remainingProjectUuids.remove(p.getProjectUuid());
            bulkIndexers.forEach(bi -> bi.add(AuthorizationDoc.fromDto((IndexType)bi.getIndexType(), (IndexPermissions)p).toIndexRequest()));
        });
        remainingProjectUuids.forEach(projectUuid -> bulkIndexers.forEach(bi -> {
            String authorizationDocId = AuthorizationDoc.idOf((String)projectUuid);
            bi.addDeletion(bi.getIndexType(), authorizationDocId, authorizationDocId);
        }));
        bulkIndexers.forEach(b -> result.add(b.stop()));
        return result;
    }

    private Stream<AuthorizationScope> getScopes(Set<IndexType> indexTypes) {
        return this.authorizationScopes.stream().filter(scope -> indexTypes.contains(scope.getIndexType()));
    }

    private List<IndexPermissions> getAllAuthorizations() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<IndexPermissions> list = new PermissionIndexerDao().selectAll(this.dbClient, dbSession);
            return list;
        }
    }

    private static /* synthetic */ IndexRequest lambda$index$3(IndexType indexType, IndexPermissions dto) {
        return AuthorizationDoc.fromDto((IndexType)indexType, (IndexPermissions)dto).toIndexRequest();
    }
}

