/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.i18n.I18n;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionTemplateService;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.project.Visibility;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsParameterBuilder;

public class BulkApplyTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionTemplateService permissionTemplateService;
    private final PermissionWsSupport wsSupport;
    private final I18n i18n;
    private final ResourceTypes resourceTypes;

    public BulkApplyTemplateAction(DbClient dbClient, UserSession userSession, PermissionTemplateService permissionTemplateService, PermissionWsSupport wsSupport, I18n i18n, ResourceTypes resourceTypes) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.permissionTemplateService = permissionTemplateService;
        this.wsSupport = wsSupport;
        this.i18n = i18n;
        this.resourceTypes = resourceTypes;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("bulk_apply_template").setDescription("Apply a permission template to several projects.<br />The template id or name must be provided.<br />Requires the following permission: 'Administer System'.").setPost(true).setSince("5.5").setChangelog(new Change[]{new Change("6.7.2", String.format("Parameter %s accepts maximum %d values", "projects", 1000))}).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to: <ul><li>project names that contain the supplied string</li><li>project keys that are exactly the same as the supplied string</li></ul>").setExampleValue((Object)"apac");
        WsParameterBuilder.createRootQualifiersParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes)).setDefaultValue((Object)"TRK").setDeprecatedKey("qualifier", "6.6");
        WsParameters.createTemplateParameters(action);
        action.createParam("projects").setDescription("Comma-separated list of project keys").setSince("6.6").setMaxValuesAllowed(Integer.valueOf(1000)).setExampleValue((Object)String.join((CharSequence)",", "my_project", "another_project"));
        action.createParam("visibility").setDescription("Filter the projects that should be visible to everyone (%s), or only specific user/groups (%s).<br/>If no visibility is specified, the default project visibility of the organization will be used.", new Object[]{Visibility.PUBLIC.getLabel(), Visibility.PRIVATE.getLabel()}).setRequired(false).setInternal(true).setSince("6.6").setPossibleValues(Visibility.getLabels());
        action.createParam("analyzedBefore").setDescription("Filter the projects for which last analysis is older than the given date (exclusive).<br> Either a date (server timezone) or datetime can be provided.").setSince("6.6").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("onProvisionedOnly").setDescription("Filter the projects that are provisioned").setBooleanPossibleValues().setDefaultValue((Object)"false").setSince("6.6");
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(BulkApplyTemplateAction.toBulkApplyTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(BulkApplyTemplateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            ComponentQuery componentQuery = BulkApplyTemplateAction.buildDbQuery(request);
            List projects = this.dbClient.componentDao().selectByQuery(dbSession, template.getOrganizationUuid(), componentQuery, 0, Integer.MAX_VALUE);
            this.permissionTemplateService.applyAndCommit(dbSession, template, projects);
        }
    }

    private static BulkApplyTemplateRequest toBulkApplyTemplateWsRequest(Request request) {
        return new BulkApplyTemplateRequest().setOrganization(request.param("organization")).setTemplateId(request.param("templateId")).setTemplateName(request.param("templateName")).setQualifiers(request.mandatoryParamAsStrings("qualifiers")).setQuery(request.param("q")).setVisibility(request.param("visibility")).setOnProvisionedOnly(request.mandatoryParamAsBoolean("onProvisionedOnly")).setAnalyzedBefore(request.param("analyzedBefore")).setProjects(request.paramAsStrings("projects"));
    }

    private static ComponentQuery buildDbQuery(BulkApplyTemplateRequest request) {
        Collection<String> qualifiers = request.getQualifiers();
        ComponentQuery.Builder query = ComponentQuery.builder().setQualifiers(qualifiers.toArray(new String[qualifiers.size()]));
        Optional.ofNullable(request.getQuery()).ifPresent(q -> {
            query.setNameOrKeyQuery(q);
            query.setPartialMatchOnKey(Boolean.valueOf(true));
        });
        Optional.ofNullable(request.getVisibility()).ifPresent(v -> query.setPrivate(Boolean.valueOf(Visibility.isPrivate(v))));
        Optional.ofNullable(request.getAnalyzedBefore()).ifPresent(d -> query.setAnalyzedBefore(Long.valueOf(DateUtils.parseDateOrDateTime((String)d).getTime())));
        query.setOnProvisionedOnly(request.isOnProvisionedOnly());
        Optional.ofNullable(request.getProjects()).ifPresent(keys -> query.setComponentKeys(new HashSet(keys)));
        return query.build();
    }

    private static class BulkApplyTemplateRequest {
        private String templateId;
        private String organization;
        private String templateName;
        private String query;
        private Collection<String> qualifiers = Collections.singleton("TRK");
        private String visibility;
        private String analyzedBefore;
        private boolean onProvisionedOnly = false;
        private Collection<String> projects;

        private BulkApplyTemplateRequest() {
        }

        @CheckForNull
        public String getTemplateId() {
            return this.templateId;
        }

        public BulkApplyTemplateRequest setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        public BulkApplyTemplateRequest setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }

        @CheckForNull
        public String getTemplateName() {
            return this.templateName;
        }

        public BulkApplyTemplateRequest setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }

        @CheckForNull
        public String getQuery() {
            return this.query;
        }

        public BulkApplyTemplateRequest setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Collection<String> getQualifiers() {
            return this.qualifiers;
        }

        public BulkApplyTemplateRequest setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = Objects.requireNonNull(qualifiers);
            return this;
        }

        @CheckForNull
        public String getVisibility() {
            return this.visibility;
        }

        public BulkApplyTemplateRequest setVisibility(@Nullable String visibility) {
            this.visibility = visibility;
            return this;
        }

        @CheckForNull
        public String getAnalyzedBefore() {
            return this.analyzedBefore;
        }

        public BulkApplyTemplateRequest setAnalyzedBefore(@Nullable String analyzedBefore) {
            this.analyzedBefore = analyzedBefore;
            return this;
        }

        public boolean isOnProvisionedOnly() {
            return this.onProvisionedOnly;
        }

        public BulkApplyTemplateRequest setOnProvisionedOnly(boolean onProvisionedOnly) {
            this.onProvisionedOnly = onProvisionedOnly;
            return this;
        }

        @CheckForNull
        public Collection<String> getProjects() {
            return this.projects;
        }

        public BulkApplyTemplateRequest setProjects(@Nullable Collection<String> projects) {
            this.projects = projects;
            return this;
        }
    }
}

