/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.organization.DefaultTemplates;

public interface DefaultTemplatesResolver {
    public ResolvedDefaultTemplates resolve(DefaultTemplates var1);

    @Immutable
    public static final class ResolvedDefaultTemplates {
        private final String project;
        private final String application;
        private final String portfolio;

        ResolvedDefaultTemplates(String project, @Nullable String application, @Nullable String portfolio) {
            this.project = Objects.requireNonNull(project, "project can't be null");
            this.application = application;
            this.portfolio = portfolio;
        }

        public String getProject() {
            return this.project;
        }

        public Optional<String> getApplication() {
            return Optional.ofNullable(this.application);
        }

        public Optional<String> getPortfolio() {
            return Optional.ofNullable(this.portfolio);
        }
    }
}

