/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.util.Optional;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.db.migration.version.DatabaseVersion;

public class DatabaseServerCompatibility
implements Startable {
    private static final String HIGHLIGHTER = "################################################################################";
    private final DatabaseVersion version;
    private final Configuration configuration;

    public DatabaseServerCompatibility(DatabaseVersion version, Configuration configuration) {
        this.version = version;
        this.configuration = configuration;
    }

    public void start() {
        DatabaseVersion.Status status = this.version.getStatus();
        if (status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
            throw MessageException.of((String)"Database was upgraded to a more recent version of SonarQube. A backup must probably be restored or the DB settings are incorrect.");
        }
        if (status == DatabaseVersion.Status.REQUIRES_UPGRADE) {
            Optional currentVersion = this.version.getVersion();
            if (currentVersion.isPresent() && (Long)currentVersion.get() < 1830L) {
                throw MessageException.of((String)"Current version is too old. Please upgrade to Long Term Support version firstly.");
            }
            boolean blueGreen = this.configuration.getBoolean(ProcessProperties.Property.BLUE_GREEN_ENABLED.getKey()).orElse(false);
            if (!blueGreen) {
                String msg = "The database must be manually upgraded. Please backup the database and browse /setup. For more information: https://docs.sonarqube.org/latest/setup/upgrading";
                Loggers.get(DatabaseServerCompatibility.class).warn(msg);
                Logger logger = Loggers.get((String)"startup");
                logger.warn(HIGHLIGHTER);
                logger.warn(msg);
                logger.warn(HIGHLIGHTER);
            }
        }
    }

    public void stop() {
    }
}

