/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.server.app.ProcessCommandWrapper;
import org.sonar.server.platform.db.migration.version.DatabaseVersion;
import org.sonar.server.platform.platformlevel.PlatformLevel;
import org.sonar.server.platform.platformlevel.PlatformLevel1;
import org.sonar.server.platform.platformlevel.PlatformLevel2;
import org.sonar.server.platform.platformlevel.PlatformLevel3;
import org.sonar.server.platform.platformlevel.PlatformLevel4;
import org.sonar.server.platform.platformlevel.PlatformLevelSafeMode;
import org.sonar.server.platform.platformlevel.PlatformLevelStartup;

public class Platform {
    private static final Logger LOGGER = Loggers.get(Platform.class);
    private static final Platform INSTANCE = new Platform();
    private final Supplier<AutoStarter> autoStarterSupplier;
    private AutoStarter autoStarter = null;
    private Properties properties;
    private ServletContext servletContext;
    private PlatformLevel level1;
    private PlatformLevel level2;
    private PlatformLevel levelSafeMode;
    private PlatformLevel level3;
    private PlatformLevel level4;
    private PlatformLevel currentLevel;
    private boolean dbConnected = false;
    private boolean started = false;
    private final List<Object> level4AddedComponents = Lists.newArrayList();
    private final Profiler profiler = Profiler.createIfTrace((Logger)Loggers.get(Platform.class));

    private Platform() {
        this.autoStarterSupplier = () -> {
            ProcessCommandWrapper processCommandWrapper = (ProcessCommandWrapper)this.getContainer().getComponentByType(ProcessCommandWrapper.class);
            return new AsynchronousAutoStarter(processCommandWrapper);
        };
    }

    protected Platform(Supplier<AutoStarter> autoStarterSupplier) {
        this.autoStarterSupplier = autoStarterSupplier;
    }

    public static Platform getInstance() {
        return INSTANCE;
    }

    public void init(Properties properties, ServletContext servletContext) {
        this.properties = properties;
        this.servletContext = servletContext;
        if (!this.dbConnected) {
            this.startLevel1Container();
            this.startLevel2Container();
            this.currentLevel = this.level2;
            this.dbConnected = true;
        }
    }

    public void doStart() {
        this.doStart(Startup.ALL);
    }

    protected void doStart(final Startup startup) {
        if (this.started && !this.isInSafeMode()) {
            return;
        }
        final boolean dbRequiredMigration = this.dbRequiresMigration();
        this.startSafeModeContainer();
        this.currentLevel = this.levelSafeMode;
        this.started = true;
        if (this.dbRequiresMigration()) {
            LOGGER.info("Database needs to be migrated. Please refer to https://docs.sonarqube.org/latest/setup/upgrading");
        } else {
            this.autoStarter = this.autoStarterSupplier.get();
            this.autoStarter.execute(new AutoStarterRunnable(this.autoStarter){

                @Override
                public void doRun() {
                    if (dbRequiredMigration) {
                        LOGGER.info("Database has been automatically updated");
                    }
                    this.runIfNotAborted(() -> Platform.this.startLevel34Containers());
                    this.runIfNotAborted(() -> Platform.this.executeStartupTasks(startup));
                    this.runIfNotAborted(() -> {
                        Platform.this.currentLevel = Platform.this.level4;
                        LOGGER.info("WebServer is operational");
                    });
                    this.runIfNotAborted(() -> Platform.this.stopSafeModeContainer());
                }
            });
        }
    }

    private boolean dbRequiresMigration() {
        return this.getDatabaseStatus() != DatabaseVersion.Status.UP_TO_DATE;
    }

    public boolean isStarted() {
        return this.status() == Status.UP;
    }

    public boolean isInSafeMode() {
        return this.status() == Status.SAFEMODE;
    }

    public Status status() {
        if (!this.started) {
            return Status.BOOTING;
        }
        PlatformLevel current = this.currentLevel;
        PlatformLevel levelSafe = this.levelSafeMode;
        if (levelSafe != null && current == levelSafe) {
            return Platform.isRunning(this.autoStarter) ? Status.STARTING : Status.SAFEMODE;
        }
        if (current == this.level4) {
            return Status.UP;
        }
        return Status.BOOTING;
    }

    private static boolean isRunning(@Nullable AutoStarter autoStarter) {
        return autoStarter != null && autoStarter.isRunning();
    }

    private void startLevel1Container() {
        this.level1 = this.start(new PlatformLevel1(this, this.properties, this.servletContext));
    }

    private void startLevel2Container() {
        this.level2 = this.start(new PlatformLevel2(this.level1));
    }

    private void startLevel34Containers() {
        this.level3 = this.start(new PlatformLevel3(this.level2));
        this.level4 = this.start(new PlatformLevel4(this.level3, this.level4AddedComponents));
    }

    public void executeStartupTasks() {
        this.executeStartupTasks(Startup.ALL);
    }

    private void executeStartupTasks(Startup startup) {
        if (startup.ordinal() >= Startup.ALL.ordinal()) {
            new PlatformLevelStartup(this.level4).configure().start().stop().destroy();
        }
    }

    private void startSafeModeContainer() {
        this.levelSafeMode = this.start(new PlatformLevelSafeMode(this.level2));
    }

    private PlatformLevel start(PlatformLevel platformLevel) {
        this.profiler.start();
        platformLevel.configure();
        this.profiler.stopTrace(String.format("%s configured", platformLevel.getName()));
        this.profiler.start();
        platformLevel.start();
        this.profiler.stopTrace(String.format("%s started", platformLevel.getName()));
        return platformLevel;
    }

    private void stopLevel1Container() {
        if (this.level1 != null) {
            this.level1.stop();
            this.level1 = null;
        }
    }

    private void stopLevel234Containers() {
        if (this.level2 != null) {
            this.level2.stop();
            this.level2 = null;
            this.level3 = null;
            this.level4 = null;
        }
    }

    private void stopSafeModeContainer() {
        if (this.levelSafeMode != null) {
            this.levelSafeMode.stop();
            this.levelSafeMode = null;
        }
    }

    private DatabaseVersion.Status getDatabaseStatus() {
        DatabaseVersion version = (DatabaseVersion)this.getContainer().getComponentByType(DatabaseVersion.class);
        return version.getStatus();
    }

    public void doStop() {
        try {
            this.stopAutoStarter();
            this.stopSafeModeContainer();
            this.stopLevel234Containers();
            this.stopLevel1Container();
            this.currentLevel = null;
            this.dbConnected = false;
            this.started = false;
        }
        catch (Exception e) {
            LOGGER.error("Fail to stop server - ignored", (Throwable)e);
        }
    }

    private void stopAutoStarter() {
        if (this.autoStarter != null) {
            this.autoStarter.abort();
            this.autoStarter = null;
        }
    }

    public void addComponents(Collection<?> components) {
        this.level4AddedComponents.addAll(components);
    }

    public ComponentContainer getContainer() {
        return this.currentLevel.getContainer();
    }

    public Object getComponent(Object key) {
        return this.getContainer().getComponentByKey(key);
    }

    private static final class AsynchronousAutoStarter
    implements AutoStarter {
        private final ProcessCommandWrapper processCommandWrapper;
        private boolean running = true;
        private boolean abort = false;

        private AsynchronousAutoStarter(ProcessCommandWrapper processCommandWrapper) {
            this.processCommandWrapper = processCommandWrapper;
        }

        @Override
        public void execute(Runnable startCode) {
            new Thread(startCode, "SQ starter").start();
        }

        @Override
        public void failure(Throwable t) {
            LOGGER.error("Background initialization failed. Stopping SonarQube", t);
            this.processCommandWrapper.requestHardStop();
            this.running = false;
        }

        @Override
        public void success() {
            LOGGER.debug("Background initialization of SonarQube done");
            this.running = false;
        }

        @Override
        public void aborted() {
            LOGGER.debug("Background initialization of SonarQube aborted");
            this.running = false;
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void abort() {
            this.abort = true;
        }

        @Override
        public boolean isAborting() {
            return this.abort;
        }
    }

    private static abstract class AutoStarterRunnable
    implements Runnable {
        private final AutoStarter autoStarter;

        AutoStarterRunnable(AutoStarter autoStarter) {
            this.autoStarter = autoStarter;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                this.autoStarter.failure(t);
            }
            finally {
                if (this.autoStarter.isAborting()) {
                    this.autoStarter.aborted();
                } else {
                    this.autoStarter.success();
                }
            }
        }

        abstract void doRun();

        void runIfNotAborted(Runnable r) {
            if (!this.autoStarter.isAborting()) {
                r.run();
            }
        }
    }

    public static interface AutoStarter {
        public void execute(Runnable var1);

        public void failure(Throwable var1);

        public void success();

        public boolean isRunning();

        public void abort();

        public boolean isAborting();

        public void aborted();
    }

    public static enum Startup {
        NO_STARTUP_TASKS,
        ALL;

    }

    public static enum Status {
        BOOTING,
        SAFEMODE,
        STARTING,
        UP;

    }
}

