/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.MessageException;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.web.AbortTomcatStartException;

public final class PlatformServletContextListener
implements ServletContextListener {
    static final String STARTED_ATTRIBUTE = "sonarqube.started";

    public void contextInitialized(ServletContextEvent event) {
        try {
            Properties props = new Properties();
            ServletContext servletContext = event.getServletContext();
            Enumeration paramKeys = servletContext.getInitParameterNames();
            while (paramKeys.hasMoreElements()) {
                String key = (String)paramKeys.nextElement();
                props.put(key, servletContext.getInitParameter(key));
            }
            Platform.getInstance().init(props, servletContext);
            Platform.getInstance().doStart();
            event.getServletContext().setAttribute(STARTED_ATTRIBUTE, (Object)Boolean.TRUE);
        }
        catch (org.sonar.api.utils.MessageException | MessageException e) {
            Loggers.get(Platform.class).error("Web server startup failed: " + e.getMessage());
            this.stopQuietly();
        }
        catch (Throwable t) {
            Loggers.get(Platform.class).error("Web server startup failed", t);
            this.stopQuietly();
            throw new AbortTomcatStartException();
        }
    }

    private void stopQuietly() {
        try {
            Platform.getInstance().doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        Platform.getInstance().doStop();
    }
}

