/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.platform.WebServer;
import org.sonar.server.platform.ws.HealthActionSupport;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.SystemPasscode;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class HealthAction
implements SystemWsAction {
    private final WebServer webServer;
    private final HealthActionSupport support;
    private final SystemPasscode systemPasscode;
    private final UserSession userSession;

    public HealthAction(WebServer webServer, HealthActionSupport support, SystemPasscode systemPasscode, UserSession userSession) {
        this.webServer = webServer;
        this.support = support;
        this.systemPasscode = systemPasscode;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        this.support.define(controller, this);
    }

    public void handle(Request request, Response response) throws Exception {
        if (!this.systemPasscode.isValid(request) && !this.isSystemAdmin()) {
            throw new ForbiddenException("Insufficient privileges");
        }
        if (this.webServer.isStandalone()) {
            WsUtils.writeProtobuf((Message)this.support.checkNodeHealth(), request, response);
        } else {
            WsUtils.writeProtobuf((Message)this.support.checkClusterHealth(), request, response);
        }
    }

    private boolean isSystemAdmin() {
        return this.userSession.isSystemAdministrator();
    }
}

