/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDao;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.OrgQProfileDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;
import org.sonar.server.qualityprofile.DescendantProfilesSupplier;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivationContext;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.TypeValidations;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleActivator {
    private final System2 system2;
    private final DbClient db;
    private final TypeValidations typeValidations;
    private final UserSession userSession;

    public RuleActivator(System2 system2, DbClient db, TypeValidations typeValidations, UserSession userSession) {
        this.system2 = system2;
        this.db = db;
        this.typeValidations = typeValidations;
        this.userSession = userSession;
    }

    public List<ActiveRuleChange> activate(DbSession dbSession, RuleActivation activation, RuleActivationContext context) {
        context.reset(activation.getRuleId());
        return this.doActivate(dbSession, activation, context);
    }

    private List<ActiveRuleChange> doActivate(DbSession dbSession, RuleActivation activation, RuleActivationContext context) {
        ActiveRuleChange change;
        RuleDefinitionDto rule = context.getRule().get();
        WsUtils.checkRequest(RuleStatus.REMOVED != rule.getStatus(), "Rule was removed: %s", rule.getKey());
        WsUtils.checkRequest(!rule.isTemplate(), "Rule template can't be activated on a Quality profile: %s", rule.getKey());
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        boolean stopCascading = false;
        RuleActivationContext.ActiveRuleWrapper activeRule = context.getActiveRule();
        ActiveRuleKey activeRuleKey = ActiveRuleKey.of((RulesProfileDto)context.getRulesProfile(), (RuleKey)rule.getKey());
        if (activeRule == null) {
            if (activation.isReset()) {
                return changes;
            }
            change = new ActiveRuleChange(ActiveRuleChange.Type.ACTIVATED, activeRuleKey, rule);
            this.applySeverityAndParamToChange(activation, context, change);
            if (context.isCascading() || RuleActivator.isSameAsParent(change, context)) {
                change.setInheritance(ActiveRuleInheritance.INHERITED);
            }
        } else {
            if (context.isCascading() && activeRule.get().doesOverride()) {
                return changes;
            }
            change = new ActiveRuleChange(ActiveRuleChange.Type.UPDATED, activeRuleKey, rule);
            if (context.isCascading() && activeRule.get().getInheritance() == null) {
                change.setInheritance(ActiveRuleInheritance.OVERRIDES);
                change.setSeverity(activeRule.get().getSeverityString());
                for (ActiveRuleParamDto activeParam : activeRule.getParams()) {
                    change.setParameter(activeParam.getKey(), activeParam.getValue());
                }
                stopCascading = true;
            } else {
                this.applySeverityAndParamToChange(activation, context, change);
                if (!context.isCascading() && context.getParentActiveRule() != null) {
                    change.setInheritance(RuleActivator.isSameAsParent(change, context) ? ActiveRuleInheritance.INHERITED : ActiveRuleInheritance.OVERRIDES);
                }
            }
            if (RuleActivator.isSame(change, activeRule)) {
                change = null;
                stopCascading = true;
            }
        }
        if (change != null) {
            changes.add(change);
            this.persist(change, context, dbSession);
        }
        if (!changes.isEmpty()) {
            this.updateProfileDates(dbSession, context);
        }
        if (!stopCascading) {
            changes.addAll(this.propagateActivationToDescendants(dbSession, activation, context));
        }
        return changes;
    }

    private void updateProfileDates(DbSession dbSession, RuleActivationContext context) {
        RulesProfileDto ruleProfile = context.getRulesProfile();
        ruleProfile.setRulesUpdatedAtAsDate(new Date(context.getDate()));
        this.db.qualityProfileDao().update(dbSession, ruleProfile);
        if (this.userSession.isLoggedIn()) {
            context.getProfiles().forEach(p -> this.db.qualityProfileDao().update(dbSession, OrgQProfileDto.from((QProfileDto)p).setUserUpdatedAt(Long.valueOf(context.getDate()))));
        }
    }

    private void applySeverityAndParamToChange(RuleActivation request, RuleActivationContext context, ActiveRuleChange change) {
        RuleActivationContext.RuleWrapper rule = context.getRule();
        RuleActivationContext.ActiveRuleWrapper activeRule = context.getActiveRule();
        RuleActivationContext.ActiveRuleWrapper parentActiveRule = context.getParentActiveRule();
        String severity = request.isReset() ? RuleActivator.firstNonNull(parentActiveRule != null ? parentActiveRule.get().getSeverityString() : null, rule.get().getSeverityString()) : (context.getRulesProfile().isBuiltIn() ? RuleActivator.firstNonNull(request.getSeverity(), rule.get().getSeverityString()) : RuleActivator.firstNonNull(request.getSeverity(), activeRule == null ? null : activeRule.get().getSeverityString(), parentActiveRule != null ? parentActiveRule.get().getSeverityString() : null, rule.get().getSeverityString()));
        change.setSeverity(severity);
        for (RuleParamDto ruleParamDto : rule.getParams()) {
            String paramValue;
            String paramKey = ruleParamDto.getName();
            if (request.isReset()) {
                paramValue = RuleActivator.firstNonNull(parentActiveRule != null ? parentActiveRule.getParamValue(paramKey) : null, rule.getParamDefaultValue(paramKey));
            } else if (context.getRulesProfile().isBuiltIn()) {
                paramValue = RuleActivator.firstNonNull(context.getRequestedParamValue(request, paramKey), rule.getParamDefaultValue(paramKey));
            } else {
                String parentValue = parentActiveRule != null ? parentActiveRule.getParamValue(paramKey) : null;
                String activeRuleValue = activeRule == null ? null : activeRule.getParamValue(paramKey);
                paramValue = context.hasRequestedParamValue(request, paramKey) ? RuleActivator.firstNonNull(context.getRequestedParamValue(request, paramKey), parentValue, rule.getParamDefaultValue(paramKey)) : RuleActivator.firstNonNull(activeRuleValue, parentValue, rule.getParamDefaultValue(paramKey));
            }
            change.setParameter(paramKey, this.validateParam(ruleParamDto, paramValue));
        }
    }

    private List<ActiveRuleChange> propagateActivationToDescendants(DbSession dbSession, RuleActivation activation, RuleActivationContext context) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        context.getChildProfiles().forEach(child -> {
            context.selectChild((QProfileDto)child);
            changes.addAll(this.doActivate(dbSession, activation, context));
        });
        return changes;
    }

    private void persist(ActiveRuleChange change, RuleActivationContext context, DbSession dbSession) {
        ActiveRuleDto activeRule = null;
        if (change.getType() == ActiveRuleChange.Type.ACTIVATED) {
            activeRule = this.doInsert(change, context, dbSession);
        } else if (change.getType() == ActiveRuleChange.Type.DEACTIVATED) {
            ActiveRuleDao dao = this.db.activeRuleDao();
            activeRule = dao.delete(dbSession, change.getKey()).orElse(null);
        } else if (change.getType() == ActiveRuleChange.Type.UPDATED) {
            activeRule = this.doUpdate(change, context, dbSession);
        }
        change.setActiveRule(activeRule);
        this.db.qProfileChangeDao().insert(dbSession, change.toDto(this.userSession.getUuid()));
    }

    private ActiveRuleDto doInsert(ActiveRuleChange change, RuleActivationContext context, DbSession dbSession) {
        ActiveRuleInheritance inheritance;
        ActiveRuleDao dao = this.db.activeRuleDao();
        RuleActivationContext.RuleWrapper rule = context.getRule();
        ActiveRuleDto activeRule = new ActiveRuleDto();
        activeRule.setProfileId(context.getRulesProfile().getId());
        activeRule.setRuleId(rule.get().getId());
        activeRule.setKey(ActiveRuleKey.of((RulesProfileDto)context.getRulesProfile(), (RuleKey)rule.get().getKey()));
        String severity = change.getSeverity();
        if (severity != null) {
            activeRule.setSeverity(severity);
        }
        if ((inheritance = change.getInheritance()) != null) {
            activeRule.setInheritance(inheritance.name());
        }
        activeRule.setUpdatedAt(this.system2.now());
        activeRule.setCreatedAt(this.system2.now());
        dao.insert(dbSession, activeRule);
        for (Map.Entry param : change.getParameters().entrySet()) {
            if (param.getValue() == null) continue;
            ActiveRuleParamDto paramDto = ActiveRuleParamDto.createFor((RuleParamDto)rule.getParam((String)param.getKey()));
            paramDto.setValue((String)param.getValue());
            dao.insertParam(dbSession, activeRule, paramDto);
        }
        return activeRule;
    }

    private ActiveRuleDto doUpdate(ActiveRuleChange change, RuleActivationContext context, DbSession dbSession) {
        ActiveRuleInheritance inheritance;
        RuleActivationContext.ActiveRuleWrapper activeRule = context.getActiveRule();
        if (activeRule == null) {
            return null;
        }
        ActiveRuleDao dao = this.db.activeRuleDao();
        String severity = change.getSeverity();
        if (severity != null) {
            activeRule.get().setSeverity(severity);
        }
        if ((inheritance = change.getInheritance()) != null) {
            activeRule.get().setInheritance(inheritance.name());
        }
        activeRule.get().setUpdatedAt(this.system2.now());
        dao.update(dbSession, activeRule.get());
        for (Map.Entry param : change.getParameters().entrySet()) {
            ActiveRuleParamDto activeRuleParamDto = activeRule.getParam((String)param.getKey());
            if (activeRuleParamDto == null) {
                if (param.getValue() == null) continue;
                activeRuleParamDto = ActiveRuleParamDto.createFor((RuleParamDto)context.getRule().getParam((String)param.getKey()));
                activeRuleParamDto.setValue((String)param.getValue());
                dao.insertParam(dbSession, activeRule.get(), activeRuleParamDto);
                continue;
            }
            if (param.getValue() != null) {
                activeRuleParamDto.setValue((String)param.getValue());
                dao.updateParam(dbSession, activeRuleParamDto);
                continue;
            }
            dao.deleteParam(dbSession, activeRuleParamDto);
        }
        return activeRule.get();
    }

    public List<ActiveRuleChange> deactivate(DbSession dbSession, RuleActivationContext context, int ruleId, boolean force) {
        context.reset(ruleId);
        return this.doDeactivate(dbSession, context, force);
    }

    private List<ActiveRuleChange> doDeactivate(DbSession dbSession, RuleActivationContext context, boolean force) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        RuleActivationContext.ActiveRuleWrapper activeRule = context.getActiveRule();
        if (activeRule == null) {
            return changes;
        }
        WsUtils.checkRequest(force || context.isCascading() || activeRule.get().getInheritance() == null, "Cannot deactivate inherited rule '%s'", context.getRule().get().getKey());
        ActiveRuleChange change = new ActiveRuleChange(ActiveRuleChange.Type.DEACTIVATED, activeRule.get(), context.getRule().get());
        changes.add(change);
        this.persist(change, context, dbSession);
        context.getChildProfiles().forEach(child -> {
            context.selectChild((QProfileDto)child);
            changes.addAll(this.doDeactivate(dbSession, context, force));
        });
        if (!changes.isEmpty()) {
            this.updateProfileDates(dbSession, context);
        }
        return changes;
    }

    @CheckForNull
    private String validateParam(RuleParamDto ruleParam, @Nullable String value) {
        if (value != null) {
            RuleParamType ruleParamType = RuleParamType.parse((String)ruleParam.getType());
            if (ruleParamType.multiple()) {
                List values = Splitter.on((String)",").splitToList((CharSequence)value);
                this.typeValidations.validate(values, ruleParamType.type(), (List<String>)ruleParamType.values());
            } else {
                this.typeValidations.validate(value, ruleParamType.type(), (List<String>)ruleParamType.values());
            }
        }
        return value;
    }

    public RuleActivationContext createContextForBuiltInProfile(DbSession dbSession, RulesProfileDto builtInProfile, Collection<Integer> ruleIds) {
        Preconditions.checkArgument((boolean)builtInProfile.isBuiltIn(), (String)"Rules profile with UUID %s is not built-in", (Object[])new Object[]{builtInProfile.getKee()});
        RuleActivationContext.Builder builder = new RuleActivationContext.Builder();
        builder.setDescendantProfilesSupplier(this.createDescendantProfilesSupplier(dbSession));
        this.completeWithRules(dbSession, builder, ruleIds);
        List profiles = this.db.qualityProfileDao().selectQProfilesByRuleProfile(dbSession, builtInProfile);
        builder.setProfiles(profiles);
        builder.setBaseProfile(builtInProfile);
        Collection ruleProfileUuids = (Collection)Stream.concat(Stream.of(builtInProfile.getKee()), profiles.stream().map(QProfileDto::getRulesProfileUuid)).collect(MoreCollectors.toHashSet((int)(profiles.size() + 1)));
        this.completeWithActiveRules(dbSession, builder, ruleIds, ruleProfileUuids);
        return builder.build();
    }

    public RuleActivationContext createContextForUserProfile(DbSession dbSession, QProfileDto profile, Collection<Integer> ruleIds) {
        Preconditions.checkArgument((!profile.isBuiltIn() ? 1 : 0) != 0, (String)"Profile with UUID %s is built-in", (Object[])new Object[]{profile.getKee()});
        RuleActivationContext.Builder builder = new RuleActivationContext.Builder();
        builder.setDescendantProfilesSupplier(this.createDescendantProfilesSupplier(dbSession));
        this.completeWithRules(dbSession, builder, ruleIds);
        ArrayList<QProfileDto> profiles = new ArrayList<QProfileDto>();
        profiles.add(profile);
        if (profile.getParentKee() != null) {
            profiles.add(this.db.qualityProfileDao().selectByUuid(dbSession, profile.getParentKee()));
        }
        builder.setProfiles(profiles);
        builder.setBaseProfile(RulesProfileDto.from((QProfileDto)profile));
        Collection ruleProfileUuids = (Collection)profiles.stream().map(QProfileDto::getRulesProfileUuid).collect(MoreCollectors.toHashSet((int)profiles.size()));
        this.completeWithActiveRules(dbSession, builder, ruleIds, ruleProfileUuids);
        return builder.build();
    }

    DescendantProfilesSupplier createDescendantProfilesSupplier(DbSession dbSession) {
        return (parents, ruleIds) -> {
            Collection profiles = this.db.qualityProfileDao().selectDescendants(dbSession, parents);
            Set ruleProfileUuids = (Set)profiles.stream().map(QProfileDto::getRulesProfileUuid).collect(MoreCollectors.toHashSet());
            Collection activeRules = this.db.activeRuleDao().selectByRulesAndRuleProfileUuids(dbSession, ruleIds, (Collection)ruleProfileUuids);
            List activeRuleIds = (List)activeRules.stream().map(ActiveRuleDto::getId).collect(MoreCollectors.toArrayList((int)activeRules.size()));
            List activeRuleParams = this.db.activeRuleDao().selectParamsByActiveRuleIds(dbSession, activeRuleIds);
            return new DescendantProfilesSupplier.Result(profiles, activeRules, activeRuleParams);
        };
    }

    private void completeWithRules(DbSession dbSession, RuleActivationContext.Builder builder, Collection<Integer> ruleIds) {
        List rules = this.db.ruleDao().selectDefinitionByIds(dbSession, ruleIds);
        builder.setRules(rules);
        builder.setRuleParams(this.db.ruleDao().selectRuleParamsByRuleIds(dbSession, ruleIds));
    }

    private void completeWithActiveRules(DbSession dbSession, RuleActivationContext.Builder builder, Collection<Integer> ruleIds, Collection<String> ruleProfileUuids) {
        Collection activeRules = this.db.activeRuleDao().selectByRulesAndRuleProfileUuids(dbSession, ruleIds, ruleProfileUuids);
        builder.setActiveRules(activeRules);
        List activeRuleIds = (List)activeRules.stream().map(ActiveRuleDto::getId).collect(MoreCollectors.toArrayList((int)activeRules.size()));
        builder.setActiveRuleParams(this.db.activeRuleDao().selectParamsByActiveRuleIds(dbSession, activeRuleIds));
    }

    private static boolean isSame(ActiveRuleChange change, RuleActivationContext.ActiveRuleWrapper activeRule) {
        ActiveRuleInheritance inheritance = change.getInheritance();
        if (inheritance != null && !inheritance.name().equals(activeRule.get().getInheritance())) {
            return false;
        }
        String severity = change.getSeverity();
        if (severity != null && !severity.equals(activeRule.get().getSeverityString())) {
            return false;
        }
        for (Map.Entry changeParam : change.getParameters().entrySet()) {
            String activeParamValue = activeRule.getParamValue((String)changeParam.getKey());
            if (changeParam.getValue() == null && activeParamValue != null) {
                return false;
            }
            if (changeParam.getValue() == null || activeParamValue != null && StringUtils.equals((String)((String)changeParam.getValue()), (String)activeParamValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameAsParent(ActiveRuleChange change, RuleActivationContext context) {
        RuleActivationContext.ActiveRuleWrapper parentActiveRule = context.getParentActiveRule();
        if (parentActiveRule == null) {
            return false;
        }
        if (!StringUtils.equals((String)change.getSeverity(), (String)parentActiveRule.get().getSeverityString())) {
            return false;
        }
        for (Map.Entry entry : change.getParameters().entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).equals(parentActiveRule.getParamValue((String)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @CheckForNull
    private static String firstNonNull(String ... strings) {
        for (String s : strings) {
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

