/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class QProfileWsSupport {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public QProfileWsSupport(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public static WebService.NewParam createOrganizationParam(WebService.NewAction action) {
        return action.createParam("organization").setDescription("Organization key. If no organization is provided, the default organization is used.").setRequired(false).setInternal(true).setExampleValue((Object)"my-org");
    }

    public OrganizationDto getOrganization(DbSession dbSession, QProfileDto profile) {
        Objects.requireNonNull(profile);
        String organizationUuid = profile.getOrganizationUuid();
        OrganizationDto organization = (OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid).orElseThrow(() -> new IllegalStateException("Cannot load organization with uuid=" + organizationUuid));
        this.checkMembershipOnPaidOrganization(organization);
        return organization;
    }

    public OrganizationDto getOrganizationByKey(DbSession dbSession, @Nullable String organizationKey) {
        String organizationOrDefaultKey = Optional.ofNullable(organizationKey).orElseGet(() -> ((DefaultOrganization)this.defaultOrganizationProvider.get()).getKey());
        OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationOrDefaultKey), "No organization with key '%s'", organizationOrDefaultKey);
        this.checkMembershipOnPaidOrganization(organization);
        return organization;
    }

    public RuleDefinitionDto getRule(DbSession dbSession, RuleKey ruleKey) {
        Optional ruleDefinitionDto = this.dbClient.ruleDao().selectDefinitionByKey(dbSession, ruleKey);
        RuleDefinitionDto rule = (RuleDefinitionDto)WsUtils.checkFoundWithOptional(ruleDefinitionDto, "Rule with key '%s' not found", ruleKey);
        WsUtils.checkRequest(!rule.isExternal(), "Operation forbidden for rule '%s' imported from an external rule engine.", ruleKey);
        return rule;
    }

    public QProfileDto getProfile(DbSession dbSession, QProfileReference ref) {
        QProfileDto profile;
        if (ref.hasKey()) {
            profile = this.dbClient.qualityProfileDao().selectByUuid(dbSession, ref.getKey());
            WsUtils.checkFound(profile, "Quality Profile with key '%s' does not exist", ref.getKey());
            this.getOrganization(dbSession, profile);
        } else {
            OrganizationDto org = this.getOrganizationByKey(dbSession, ref.getOrganizationKey().orElse(null));
            profile = this.dbClient.qualityProfileDao().selectByNameAndLanguage(dbSession, org, ref.getName(), ref.getLanguage());
            WsUtils.checkFound(profile, "Quality Profile for language '%s' and name '%s' does not exist%s", ref.getLanguage(), ref.getName(), ref.getOrganizationKey().map(o -> " in organization '" + o + "'").orElse(""));
        }
        return profile;
    }

    public QProfileDto getProfile(DbSession dbSession, OrganizationDto organization, String name, String language) {
        QProfileDto profile = this.dbClient.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, name, language);
        WsUtils.checkFound(profile, "Quality Profile for language '%s' and name '%s' does not exist in organization '%s'", language, name, organization.getKey());
        return profile;
    }

    public UserDto getUser(DbSession dbSession, OrganizationDto organization, String login) {
        UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
        WsUtils.checkFound(user, "User with login '%s' is not found'", login);
        this.checkMembership(dbSession, organization, user);
        return user;
    }

    GroupDto getGroup(DbSession dbSession, OrganizationDto organization, String groupName) {
        Optional group = this.dbClient.groupDao().selectByName(dbSession, organization.getUuid(), groupName);
        WsUtils.checkFoundWithOptional(group, "No group with name '%s' in organization '%s'", groupName, organization.getKey());
        return (GroupDto)group.get();
    }

    public void checkPermission(DbSession dbSession, QProfileDto profile) {
        OrganizationDto organization = this.getOrganization(dbSession, profile);
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, organization);
    }

    boolean canEdit(DbSession dbSession, OrganizationDto organization, QProfileDto profile) {
        if (profile.isBuiltIn() || !this.userSession.isLoggedIn()) {
            return false;
        }
        if (this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, organization)) {
            return true;
        }
        UserDto user = this.dbClient.userDao().selectByLogin(dbSession, this.userSession.getLogin());
        Preconditions.checkState((user != null ? 1 : 0) != 0, (Object)"User from session does not exist");
        return this.dbClient.qProfileEditUsersDao().exists(dbSession, profile, user) || this.dbClient.qProfileEditGroupsDao().exists(dbSession, profile, this.userSession.getGroups());
    }

    public void checkCanEdit(DbSession dbSession, OrganizationDto organization, QProfileDto profile) {
        this.checkNotBuiltIn(profile);
        if (!this.canEdit(dbSession, organization, profile)) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }

    void checkNotBuiltIn(QProfileDto profile) {
        WsUtils.checkRequest(!profile.isBuiltIn(), "Operation forbidden for built-in Quality Profile '%s' with language '%s'", profile.getName(), profile.getLanguage());
    }

    private void checkMembership(DbSession dbSession, OrganizationDto organization, UserDto user) {
        Preconditions.checkArgument((boolean)this.isMember(dbSession, organization, user.getId()), (String)"User '%s' is not member of organization '%s'", (Object[])new Object[]{user.getLogin(), organization.getKey()});
    }

    private boolean isMember(DbSession dbSession, OrganizationDto organization, int userId) {
        return this.dbClient.organizationMemberDao().select(dbSession, organization.getUuid(), userId).isPresent();
    }

    private void checkMembershipOnPaidOrganization(OrganizationDto organization) {
        if (!organization.getSubscription().equals((Object)OrganizationDto.Subscription.PAID)) {
            return;
        }
        this.userSession.checkMembership(organization);
    }
}

