/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.Request;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.rule.index.RuleQuery;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.util.EnumUtils;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleQueryFactory {
    private final DbClient dbClient;
    private final RuleWsSupport wsSupport;

    public RuleQueryFactory(DbClient dbClient, RuleWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
    }

    public RuleQuery createRuleSearchQuery(DbSession dbSession, Request request) {
        RuleQuery query = this.createRuleQuery(dbSession, request);
        query.setIncludeExternal(request.mandatoryParamAsBoolean("include_external"));
        return query;
    }

    public RuleQuery createRuleQuery(DbSession dbSession, Request request) {
        RuleQuery query = new RuleQuery();
        query.setQueryText(request.param("q"));
        query.setSeverities((Collection)request.paramAsStrings("severities"));
        query.setRepositories((Collection)request.paramAsStrings("repositories"));
        Date availableSince = request.paramAsDate("available_since");
        query.setAvailableSince(availableSince != null ? Long.valueOf(availableSince.getTime()) : null);
        query.setStatuses(EnumUtils.toEnums(request.paramAsStrings("statuses"), RuleStatus.class));
        this.setProfile(dbSession, query, request);
        this.setOrganization(dbSession, query, request);
        this.setCompareToProfile(dbSession, query, request);
        QProfileDto profile = query.getQProfile();
        query.setLanguages((Collection)(profile == null ? request.paramAsStrings("languages") : ImmutableList.of((Object)profile.getLanguage())));
        if (this.wsSupport.areActiveRulesVisible(query.getOrganization())) {
            query.setActivation(request.paramAsBoolean("activation"));
        }
        query.setTags((Collection)request.paramAsStrings("tags"));
        query.setInheritance((Collection)request.paramAsStrings("inheritance"));
        query.setActiveSeverities((Collection)request.paramAsStrings("active_severities"));
        query.setIsTemplate(request.paramAsBoolean("is_template"));
        query.setTemplateKey(request.param("template_key"));
        query.setTypes(EnumUtils.toEnums(request.paramAsStrings("types"), RuleType.class));
        query.setKey(request.param("rule_key"));
        query.setCwe((Collection)request.paramAsStrings("cwe"));
        query.setOwaspTop10((Collection)request.paramAsStrings("owaspTop10"));
        query.setSansTop25((Collection)request.paramAsStrings("sansTop25"));
        query.setSonarsourceSecurity((Collection)request.paramAsStrings("sonarsourceSecurity"));
        String sortParam = request.param("s");
        if (sortParam != null) {
            query.setSortField(sortParam);
            query.setAscendingSort(request.mandatoryParamAsBoolean("asc"));
        }
        return query;
    }

    private void setProfile(DbSession dbSession, RuleQuery query, Request request) {
        String profileUuid = request.param("qprofile");
        if (profileUuid == null) {
            return;
        }
        QProfileDto profileOptional = this.dbClient.qualityProfileDao().selectByUuid(dbSession, profileUuid);
        QProfileDto profile = WsUtils.checkFound(profileOptional, "The specified qualityProfile '%s' does not exist", profileUuid);
        query.setQProfile(profile);
    }

    private void setOrganization(DbSession dbSession, RuleQuery query, Request request) {
        String organizationKey = request.param("organization");
        QProfileDto profile = query.getQProfile();
        if (profile == null) {
            query.setOrganization(this.wsSupport.getOrganizationByKey(dbSession, organizationKey));
            return;
        }
        OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByUuid(dbSession, profile.getOrganizationUuid()), "No organization with UUID %s", profile.getOrganizationUuid());
        if (organizationKey != null) {
            OrganizationDto inputOrganization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization with key '%s'", organizationKey);
            Preconditions.checkArgument((boolean)organization.getUuid().equals(inputOrganization.getUuid()), (Object)String.format("The specified quality profile '%s' is not part of the specified organization '%s'", profile.getKee(), organizationKey));
        }
        query.setOrganization(organization);
    }

    private void setCompareToProfile(DbSession dbSession, RuleQuery query, Request request) {
        String compareToProfileUuid = request.param("compareToProfile");
        if (compareToProfileUuid == null) {
            return;
        }
        QProfileDto profileOptional = this.dbClient.qualityProfileDao().selectByUuid(dbSession, compareToProfileUuid);
        QProfileDto profile = WsUtils.checkFound(profileOptional, "The specified qualityProfile '%s' does not exist", compareToProfileUuid);
        Preconditions.checkArgument((boolean)query.getOrganization().getUuid().equals(profile.getOrganizationUuid()), (Object)String.format("The specified quality profile '%s' is not part of the specified organization '%s'", profile.getKee(), query.getOrganization().getKey()));
        query.setCompareToQProfile(profile);
    }
}

