/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import okhttp3.HttpUrl;
import org.picocontainer.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.webhook.WebhookDto;

public class DeprecatedWebhookUsageCheck
implements Startable {
    private static final Logger LOG = Loggers.get(DeprecatedWebhookUsageCheck.class);
    private final DbClient dbClient;

    public DeprecatedWebhookUsageCheck(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.webhookDao().scrollAll(dbSession, new WebhookConsumer((DbClient)this.dbClient, (DbSession)dbSession).consumer);
        }
    }

    public void stop() {
    }

    static class WebhookConsumer {
        private DbClient dbClient;
        private DbSession session;
        final Consumer<WebhookDto> consumer = webhookDto -> {
            HttpUrl url = HttpUrl.parse((String)webhookDto.getUrl());
            if (url != null) {
                try {
                    InetAddress address = InetAddress.getByName(url.host());
                    if (address.isLoopbackAddress() || address.isAnyLocalAddress()) {
                        if (webhookDto.getProjectUuid() != null) {
                            ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(this.session, webhookDto.getProjectUuid());
                            LOG.warn("Webhook '{}' for project '{}' uses an invalid, unsafe URL and will be automatically removed in a future version of SonarQube. You should update the URL of that webhook or ask a project administrator to do it.", (Object)webhookDto.getName(), (Object)project.name());
                        } else {
                            LOG.warn("Global webhook '{}' uses an invalid, unsafe URL and will be automatically removed in a future version of SonarQube. You should update the URL of that webhook.", (Object)webhookDto.getName());
                        }
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        };

        WebhookConsumer(DbClient dbClient, DbSession session) {
            this.dbClient = dbClient;
            this.session = session;
        }
    }
}

