/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.picocontainer.Startable;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;

public class RegisterMetrics
implements Startable {
    private static final Logger LOG = Loggers.get(RegisterMetrics.class);
    private final DbClient dbClient;
    private final Metrics[] metricsRepositories;

    public RegisterMetrics(DbClient dbClient, Metrics[] metricsRepositories) {
        this.dbClient = dbClient;
        this.metricsRepositories = metricsRepositories;
    }

    public RegisterMetrics(DbClient dbClient) {
        this(dbClient, new Metrics[0]);
    }

    public void start() {
        this.register(Iterables.concat((Iterable)CoreMetrics.getMetrics(), this.getPluginMetrics()));
    }

    public void stop() {
    }

    void register(Iterable<Metric> metrics) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Register metrics");
        try (DbSession session = this.dbClient.openSession(false);){
            this.save(session, metrics);
            this.sanitizeQualityGates(session);
            session.commit();
        }
        profiler.stopDebug();
    }

    private void sanitizeQualityGates(DbSession session) {
        this.dbClient.gateConditionDao().deleteConditionsWithInvalidMetrics(session);
    }

    private void save(DbSession session, Iterable<Metric> metrics) {
        HashMap<String, MetricDto> basesByKey = new HashMap<String, MetricDto>();
        for (MetricDto base : FluentIterable.from((Iterable)this.dbClient.metricDao().selectAll(session)).toList()) {
            basesByKey.put(base.getKey(), base);
        }
        for (Metric metric : metrics) {
            MetricDto dto = MetricToDto.INSTANCE.apply(metric);
            MetricDto base = (MetricDto)basesByKey.get(metric.getKey());
            if (base == null) {
                this.dbClient.metricDao().insert(session, dto);
            } else if (!base.isUserManaged()) {
                dto.setId(base.getId());
                this.dbClient.metricDao().update(session, dto);
            }
            basesByKey.remove(metric.getKey());
        }
        for (MetricDto nonUpdatedBase : basesByKey.values()) {
            if (nonUpdatedBase.isUserManaged() || !this.dbClient.metricDao().disableCustomByKey(session, nonUpdatedBase.getKey())) continue;
            LOG.info("Disable metric {} [{}]", (Object)nonUpdatedBase.getShortName(), (Object)nonUpdatedBase.getKey());
        }
    }

    @VisibleForTesting
    List<Metric> getPluginMetrics() {
        ArrayList metricsToRegister = Lists.newArrayList();
        HashMap metricsByRepository = Maps.newHashMap();
        for (Metrics metrics : this.metricsRepositories) {
            this.checkMetrics(metricsByRepository, metrics);
            metricsToRegister.addAll(metrics.getMetrics());
        }
        return metricsToRegister;
    }

    private void checkMetrics(Map<String, Metrics> metricsByRepository, Metrics metrics) {
        for (Metric metric : metrics.getMetrics()) {
            String metricKey = metric.getKey();
            if (CoreMetrics.getMetrics().contains(metric)) {
                throw new IllegalStateException(String.format("Metric [%s] is already defined by SonarQube", metricKey));
            }
            Metrics anotherRepository = metricsByRepository.get(metricKey);
            if (anotherRepository != null) {
                throw new IllegalStateException(String.format("Metric [%s] is already defined by the repository [%s]", metricKey, anotherRepository));
            }
            metricsByRepository.put(metricKey, metrics);
        }
    }

    public static enum MetricToDto implements Function<Metric, MetricDto>
    {
        INSTANCE;


        @Nonnull
        public MetricDto apply(@Nonnull Metric metric) {
            MetricDto dto = new MetricDto();
            dto.setId(metric.getId());
            dto.setKey(metric.getKey());
            dto.setDescription(metric.getDescription());
            dto.setShortName(metric.getName());
            dto.setBestValue(metric.getBestValue());
            dto.setDomain(metric.getDomain());
            dto.setEnabled(metric.getEnabled().booleanValue());
            dto.setDirection(metric.getDirection().intValue());
            dto.setHidden(metric.isHidden().booleanValue());
            dto.setQualitative(metric.getQualitative().booleanValue());
            dto.setValueType(metric.getType().name());
            dto.setOptimizedBestValue(metric.isOptimizedBestValue().booleanValue());
            dto.setUserManaged(metric.getUserManaged().booleanValue());
            dto.setWorstValue(metric.getWorstValue());
            dto.setDeleteHistoricalData(metric.getDeleteHistoricalData().booleanValue());
            dto.setDecimalScale(metric.getDecimalScale());
            return dto;
        }
    }
}

