/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserMembershipDto;
import org.sonar.db.user.UserMembershipQuery;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupId;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;

public class UsersAction
implements UserGroupsWsAction {
    private static final String FIELD_SELECTED = "selected";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LOGIN = "login";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport support;

    public UsersAction(DbClient dbClient, UserSession userSession, GroupWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("users").setDescription("Search for users with membership information with respect to a group.<br>Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this).setSince("5.2").setResponseExample(this.getClass().getResource("users-example.json")).addSelectionModeParam().addSearchQuery("freddy", new String[]{"names", "logins"}).addPagingParams(25);
        GroupWsSupport.defineGroupWsParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        int pageSize = request.mandatoryParamAsInt("ps");
        int page = request.mandatoryParamAsInt("p");
        String queryString = request.param("q");
        String selected = request.mandatoryParam(FIELD_SELECTED);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            GroupId group = this.support.findGroup(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, group.getOrganizationUuid());
            UserMembershipQuery query = UserMembershipQuery.builder().groupId(Integer.valueOf(group.getId())).organizationUuid(group.getOrganizationUuid()).memberSearch(queryString).membership(UsersAction.getMembership(selected)).pageIndex(Integer.valueOf(page)).pageSize(Integer.valueOf(pageSize)).build();
            int total = this.dbClient.groupMembershipDao().countMembers(dbSession, query);
            Paging paging = Paging.forPageIndex((int)page).withPageSize(pageSize).andTotal(total);
            List users = this.dbClient.groupMembershipDao().selectMembers(dbSession, query, paging.offset(), paging.pageSize());
            try (JsonWriter json = response.newJsonWriter();){
                json.beginObject();
                UsersAction.writeMembers(json, users);
                UsersAction.writePaging(json, paging);
                json.endObject();
            }
        }
    }

    private static void writeMembers(JsonWriter json, List<UserMembershipDto> users) {
        json.name("users").beginArray();
        for (UserMembershipDto user : users) {
            json.beginObject().prop(FIELD_LOGIN, user.getLogin()).prop(FIELD_NAME, user.getName()).prop(FIELD_SELECTED, user.getGroupId() != null).endObject();
        }
        json.endArray();
    }

    private static void writePaging(JsonWriter json, Paging paging) {
        json.prop("p", (long)paging.pageIndex()).prop("ps", (long)paging.pageSize()).prop("total", (long)paging.total());
    }

    private static String getMembership(String selected) {
        WebService.SelectionMode selectionMode = WebService.SelectionMode.fromParam((String)selected);
        String membership = "ANY";
        if (WebService.SelectionMode.SELECTED == selectionMode) {
            membership = "IN";
        } else if (WebService.SelectionMode.DESELECTED == selectionMode) {
            membership = "OUT";
        }
        return membership;
    }
}

