/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task;

import java.util.Objects;
import java.util.Optional;
import org.sonar.db.ce.CeActivityDto;

public abstract class CeTaskInterruptedException
extends RuntimeException {
    private final CeActivityDto.Status status;

    protected CeTaskInterruptedException(String message, CeActivityDto.Status status) {
        super(message);
        this.status = Objects.requireNonNull(status, "status can't be null");
    }

    public CeActivityDto.Status getStatus() {
        return this.status;
    }

    public static Optional<CeTaskInterruptedException> isTaskInterruptedException(Throwable e) {
        if (e instanceof CeTaskInterruptedException) {
            return Optional.of((CeTaskInterruptedException)e);
        }
        return CeTaskInterruptedException.isCauseInterruptedException(e);
    }

    private static Optional<CeTaskInterruptedException> isCauseInterruptedException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null || cause == e) {
            return Optional.empty();
        }
        if (cause instanceof CeTaskInterruptedException) {
            return Optional.of((CeTaskInterruptedException)cause);
        }
        return CeTaskInterruptedException.isCauseInterruptedException(cause);
    }
}

