/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.ParenthesizedExpressionTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

@Rule(key="S1067")
public class TooComplexExpressionCheck
implements SlangCheck {
    private static final int DEFAULT_MAX_COMPLEXITY = 3;
    @RuleProperty(key="max", description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    public int max = 3;

    @Override
    public void initialize(InitContext init) {
        init.register(BinaryExpressionTree.class, (ctx, tree) -> {
            int complexity;
            if (TooComplexExpressionCheck.isParentExpression(ctx) && (complexity = TooComplexExpressionCheck.computeExpressionComplexity(tree)) > this.max) {
                String message2 = String.format("Reduce the number of conditional operators (%s) used in the expression (maximum allowed %s).", complexity, this.max);
                double gap = (double)complexity - (double)this.max;
                ctx.reportIssue((HasTextRange)tree, message2, Collections.emptyList(), gap);
            }
        });
    }

    private static boolean isParentExpression(CheckContext ctx) {
        for (Tree parentExpression : ctx.ancestors()) {
            if (parentExpression instanceof BinaryExpressionTree) {
                return false;
            }
            if (parentExpression instanceof UnaryExpressionTree && parentExpression instanceof ParenthesizedExpressionTree) continue;
            return true;
        }
        return true;
    }

    private static int computeExpressionComplexity(Tree originalTree) {
        Tree tree = ExpressionUtils.skipParentheses(originalTree);
        if (tree instanceof BinaryExpressionTree) {
            int complexity = ExpressionUtils.isLogicalBinaryExpression(tree) ? 1 : 0;
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            return complexity + TooComplexExpressionCheck.computeExpressionComplexity(binary.leftOperand()) + TooComplexExpressionCheck.computeExpressionComplexity(binary.rightOperand());
        }
        if (tree instanceof UnaryExpressionTree) {
            return TooComplexExpressionCheck.computeExpressionComplexity(((UnaryExpressionTree)tree).operand());
        }
        return 0;
    }
}

