/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.hz;

import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.process.cluster.hz.HazelcastMember;

public class DistributedAnswer<T> {
    private final Map<Member, T> answers = new HashMap<Member, T>();
    private final Set<Member> timedOutMembers = new HashSet<Member>();
    private final Map<Member, Exception> failedMembers = new HashMap<Member, Exception>();

    public Optional<T> getAnswer(Member member) {
        return Optional.ofNullable(this.answers.get(member));
    }

    public boolean hasTimedOut(Member member) {
        return this.timedOutMembers.contains(member);
    }

    public Optional<Exception> getFailed(Member member) {
        return Optional.ofNullable(this.failedMembers.get(member));
    }

    public Collection<Member> getMembers() {
        ArrayList<Member> members = new ArrayList<Member>();
        members.addAll(this.answers.keySet());
        members.addAll(this.timedOutMembers);
        members.addAll(this.failedMembers.keySet());
        return members;
    }

    public void setAnswer(Member member, T answer) {
        this.answers.put(member, answer);
    }

    public void setTimedOut(Member member) {
        this.timedOutMembers.add(member);
    }

    public void setFailed(Member member, Exception e) {
        this.failedMembers.put(member, e);
    }

    public void propagateExceptions() {
        if (!this.failedMembers.isEmpty()) {
            String failedMemberNames = this.failedMembers.keySet().stream().map(m -> m.getStringAttribute(HazelcastMember.Attribute.NODE_NAME.getKey())).collect(Collectors.joining(", "));
            throw new IllegalStateException("Distributed cluster action in cluster nodes " + failedMemberNames + " (other nodes may have timed out)", this.failedMembers.values().iterator().next());
        }
        if (!this.timedOutMembers.isEmpty()) {
            String timedOutMemberNames = this.timedOutMembers.stream().map(m -> m.getStringAttribute(HazelcastMember.Attribute.NODE_NAME.getKey())).collect(Collectors.joining(", "));
            throw new IllegalStateException("Distributed cluster action timed out in cluster nodes " + timedOutMemberNames);
        }
    }
}

