/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ProjectAttributes {
    private final String projectVersion;
    @Nullable
    private final String buildString;
    @Nullable
    private final String scmRevisionId;

    public ProjectAttributes(String projectVersion, @Nullable String buildString, @Nullable String scmRevisionId) {
        this.projectVersion = Objects.requireNonNull(projectVersion, "project version can't be null");
        this.buildString = buildString;
        this.scmRevisionId = scmRevisionId;
    }

    public ProjectAttributes(ProjectAttributes projectAttributes) {
        this.projectVersion = projectAttributes.projectVersion;
        this.buildString = projectAttributes.buildString;
        this.scmRevisionId = projectAttributes.scmRevisionId;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public Optional<String> getBuildString() {
        return Optional.ofNullable(this.buildString);
    }

    public Optional<String> getScmRevisionId() {
        return Optional.ofNullable(this.scmRevisionId);
    }

    public String toString() {
        return "ProjectAttributes{projectVersion='" + this.projectVersion + '\'' + "buildString='" + this.buildString + '\'' + "scmRevisionId='" + this.scmRevisionId + '\'' + '}';
    }
}

