/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.KeyWithUuidDto;

public class SiblingComponentsWithOpenIssues {
    private final DbClient dbClient;
    private final AnalysisMetadataHolder metadataHolder;
    private final TreeRootHolder treeRootHolder;
    private Map<String, Set<String>> uuidsByKey;

    public SiblingComponentsWithOpenIssues(TreeRootHolder treeRootHolder, AnalysisMetadataHolder metadataHolder, DbClient dbClient) {
        this.treeRootHolder = treeRootHolder;
        this.metadataHolder = metadataHolder;
        this.dbClient = dbClient;
    }

    private void loadUuidsByKey() {
        String currentBranchUuid = this.treeRootHolder.getRoot().getUuid();
        String longLivingReferenceBranchUuid = this.metadataHolder.isSLBorPR() ? this.metadataHolder.getBranch().getMergeBranchUuid() : currentBranchUuid;
        this.uuidsByKey = new HashMap<String, Set<String>>();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List components = this.dbClient.componentDao().selectAllSiblingComponentKeysHavingOpenIssues(dbSession, longLivingReferenceBranchUuid, currentBranchUuid);
            for (KeyWithUuidDto dto : components) {
                this.uuidsByKey.computeIfAbsent(ComponentDto.removeBranchAndPullRequestFromKey((String)dto.key()), s -> new HashSet()).add(dto.uuid());
            }
        }
    }

    public Set<String> getUuids(String componentKey) {
        if (this.uuidsByKey == null) {
            this.loadUuidsByKey();
        }
        return this.uuidsByKey.getOrDefault(componentKey, Collections.emptySet());
    }
}

