/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.duplication;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplicate;
import org.sonar.ce.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;

@Immutable
public final class Duplication {
    private static final Comparator<Duplicate> DUPLICATE_COMPARATOR = DuplicateComparatorByType.INSTANCE.thenComparing(DuplicateToFileKey.INSTANCE).thenComparing(DuplicateToTextBlock.INSTANCE);
    private final TextBlock original;
    private final SortedSet<Duplicate> duplicates;

    public Duplication(TextBlock original, List<Duplicate> duplicates) {
        this.original = Objects.requireNonNull(original, "original TextBlock can not be null");
        Duplication.validateDuplicates(original, duplicates);
        this.duplicates = new TreeSet<Duplicate>(DUPLICATE_COMPARATOR);
        this.duplicates.addAll(duplicates);
    }

    private static void validateDuplicates(TextBlock original, List<Duplicate> duplicates) {
        Objects.requireNonNull(duplicates, "duplicates can not be null");
        Preconditions.checkArgument((!duplicates.isEmpty() ? 1 : 0) != 0, (Object)"duplicates can not be empty");
        for (Duplicate dup : duplicates) {
            Objects.requireNonNull(dup, "duplicates can not contain null");
            if (!(dup instanceof InnerDuplicate)) continue;
            Preconditions.checkArgument((!original.equals(dup.getTextBlock()) ? 1 : 0) != 0, (Object)"TextBlock of an InnerDuplicate can not be the original TextBlock");
        }
    }

    public TextBlock getOriginal() {
        return this.original;
    }

    public SortedSet<Duplicate> getDuplicates() {
        return this.duplicates;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duplication that = (Duplication)o;
        return this.original.equals(that.original) && this.duplicates.equals(that.duplicates);
    }

    public int hashCode() {
        return Objects.hash(this.original, this.duplicates);
    }

    public String toString() {
        return "Duplication{original=" + this.original + ", duplicates=" + this.duplicates + '}';
    }

    private static enum DuplicateToFileKey implements Function<Duplicate, String>
    {
        INSTANCE;


        @Override
        @Nonnull
        public String apply(@Nonnull Duplicate duplicate) {
            if (duplicate instanceof InnerDuplicate) {
                return "";
            }
            if (duplicate instanceof InProjectDuplicate) {
                return ((InProjectDuplicate)duplicate).getFile().getDbKey();
            }
            if (duplicate instanceof CrossProjectDuplicate) {
                return ((CrossProjectDuplicate)duplicate).getFileKey();
            }
            throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
        }
    }

    private static enum DuplicateToTextBlock implements Function<Duplicate, TextBlock>
    {
        INSTANCE;


        @Override
        @Nonnull
        public TextBlock apply(@Nonnull Duplicate input) {
            return input.getTextBlock();
        }
    }

    private static enum DuplicateComparatorByType implements Comparator<Duplicate>
    {
        INSTANCE;


        @Override
        public int compare(Duplicate o1, Duplicate o2) {
            return DuplicateComparatorByType.toIndexType(o1) - DuplicateComparatorByType.toIndexType(o2);
        }

        private static int toIndexType(Duplicate duplicate) {
            if (duplicate instanceof InnerDuplicate) {
                return 0;
            }
            if (duplicate instanceof InProjectDuplicate) {
                return 1;
            }
            if (duplicate instanceof CrossProjectDuplicate) {
                return 2;
            }
            throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
        }
    }
}

