/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import java.util.Arrays;

final class ScoreMatrix {
    private final ScoreFile[] removedFiles;
    private final ScoreFile[] newFiles;
    private final int[][] scores;
    private final int maxScore;

    public ScoreMatrix(ScoreFile[] removedFiles, ScoreFile[] newFiles, int[][] scores, int maxScore) {
        this.removedFiles = removedFiles;
        this.newFiles = newFiles;
        this.scores = scores;
        this.maxScore = maxScore;
    }

    public void accept(ScoreMatrixVisitor visitor) {
        for (int removedFileIndex = 0; removedFileIndex < this.removedFiles.length; ++removedFileIndex) {
            for (int newFileIndex = 0; newFileIndex < this.newFiles.length; ++newFileIndex) {
                int score = this.scores[removedFileIndex][newFileIndex];
                visitor.visit(this.removedFiles[removedFileIndex], this.newFiles[newFileIndex], score);
            }
        }
    }

    public String toCsv(final char separator) {
        final StringBuilder res = new StringBuilder();
        res.append("newFiles=>").append(separator);
        Arrays.stream(this.newFiles).forEach(f -> res.append(f.getFileUuid()).append('(').append(f.getLineCount()).append(')').append(separator));
        this.accept(new ScoreMatrixVisitor(){
            private ScoreFile previousRemovedFile = null;

            @Override
            public void visit(ScoreFile removedFile, ScoreFile newFile, int score) {
                if (this.previousRemovedFile != removedFile) {
                    res.append('\n').append(removedFile.getFileUuid()).append('(').append(removedFile.getLineCount()).append(')').append(separator);
                    this.previousRemovedFile = removedFile;
                }
                res.append(score).append(separator);
            }
        });
        return res.toString();
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    static class ScoreFile {
        private final String fileUuid;
        private final int lineCount;

        ScoreFile(String fileUuid, int lineCount) {
            this.fileUuid = fileUuid;
            this.lineCount = lineCount;
        }

        public String getFileUuid() {
            return this.fileUuid;
        }

        public int getLineCount() {
            return this.lineCount;
        }
    }

    @FunctionalInterface
    public static interface ScoreMatrixVisitor {
        public void visit(ScoreFile var1, ScoreFile var2, int var3);
    }
}

