/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ReportModulesPath;
import org.sonar.ce.task.projectanalysis.issue.BaseInputFactory;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.ce.task.projectanalysis.issue.ComponentsWithUnprocessedIssues;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.issue.IssueFieldsSetter;

class ProjectTrackerBaseLazyInput
extends BaseInputFactory.BaseLazyInput {
    private AnalysisMetadataHolder analysisMetadataHolder;
    private ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues;
    private DbClient dbClient;
    private IssueFieldsSetter issueUpdater;
    private ComponentIssuesLoader issuesLoader;
    private ReportModulesPath reportModulesPath;

    ProjectTrackerBaseLazyInput(AnalysisMetadataHolder analysisMetadataHolder, ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues, DbClient dbClient, IssueFieldsSetter issueUpdater, ComponentIssuesLoader issuesLoader, ReportModulesPath reportModulesPath, Component component) {
        super(dbClient, component, null);
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.componentsWithUnprocessedIssues = componentsWithUnprocessedIssues;
        this.dbClient = dbClient;
        this.issueUpdater = issueUpdater;
        this.issuesLoader = issuesLoader;
        this.reportModulesPath = reportModulesPath;
    }

    protected List<DefaultIssue> loadIssues() {
        ArrayList<DefaultIssue> result = new ArrayList<DefaultIssue>();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set dirOrModulesUuidsWithIssues = this.dbClient.issueDao().selectModuleAndDirComponentUuidsOfOpenIssuesForProjectUuid(dbSession, this.component.getUuid());
            if (!dirOrModulesUuidsWithIssues.isEmpty()) {
                Object pathByModuleKey = this.reportModulesPath.get();
                Map modulesByUuid = this.dbClient.componentDao().selectProjectAndModulesFromProjectKey(dbSession, this.component.getDbKey(), true).stream().collect(Collectors.toMap(ComponentDto::uuid, Function.identity()));
                List dirOrModulesWithIssues = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)dirOrModulesUuidsWithIssues);
                dirOrModulesWithIssues.forEach(arg_0 -> this.lambda$loadIssues$0((Map)pathByModuleKey, modulesByUuid, result, arg_0));
            }
            result.addAll(this.issuesLoader.loadOpenIssues(this.effectiveUuid));
            ArrayList<DefaultIssue> arrayList = result;
            return arrayList;
        }
    }

    private static String buildDirectoryProjectRelativePath(Map<String, String> pathByModuleKey, ComponentDto c, ComponentDto parentModule) {
        String moduleProjectRelativePath = ProjectTrackerBaseLazyInput.buildModuleProjectRelativePath(pathByModuleKey, parentModule);
        return Stream.of(moduleProjectRelativePath, c.path()).map(StringUtils::trimToNull).filter(s -> s != null && !"/".equals(s)).collect(Collectors.joining("/"));
    }

    private static String buildModuleProjectRelativePath(Map<String, String> pathByModuleKey, ComponentDto parentModule) {
        return Optional.ofNullable(pathByModuleKey.get(parentModule.getKey())).orElse(StringUtils.trimToEmpty((String)parentModule.path()));
    }

    private Collection<? extends DefaultIssue> migrateIssuesToTheRoot(List<DefaultIssue> issuesOnModule, String modulePath) {
        for (DefaultIssue i : issuesOnModule) {
            IssueChangeContext context = IssueChangeContext.createUser((Date)new Date(this.analysisMetadataHolder.getAnalysisDate()), null);
            if (StringUtils.isNotBlank((String)modulePath)) {
                this.issueUpdater.setMessage(i, "[" + modulePath + "] " + i.getMessage(), context);
            }
            this.issueUpdater.setIssueMoved(i, this.component.getUuid(), context);
            i.setComponentKey(this.component.getKey());
            i.setModuleUuid(null);
            i.setModuleUuidPath(null);
        }
        return issuesOnModule;
    }

    private /* synthetic */ void lambda$loadIssues$0(Map pathByModuleKey, Map modulesByUuid, List result, ComponentDto c) {
        List<DefaultIssue> issuesOnModuleOrDir = this.issuesLoader.loadOpenIssues(c.uuid());
        String moduleOrDirProjectRelativePath = c.qualifier().equals("BRC") ? ProjectTrackerBaseLazyInput.buildModuleProjectRelativePath(pathByModuleKey, c) : ProjectTrackerBaseLazyInput.buildDirectoryProjectRelativePath(pathByModuleKey, c, (ComponentDto)modulesByUuid.get(c.moduleUuid()));
        result.addAll(this.migrateIssuesToTheRoot(issuesOnModuleOrDir, moduleOrDirProjectRelativePath));
        this.componentsWithUnprocessedIssues.remove(c.uuid());
    }
}

