/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.issue.AdHocRuleCreator;
import org.sonar.ce.task.projectanalysis.issue.NewAdHocRule;
import org.sonar.ce.task.projectanalysis.issue.Rule;
import org.sonar.ce.task.projectanalysis.issue.RuleImpl;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.DeprecatedRuleKeyDto;
import org.sonar.db.rule.RuleDto;

public class RuleRepositoryImpl
implements RuleRepository {
    @CheckForNull
    private Map<RuleKey, Rule> rulesByKey;
    @CheckForNull
    private Map<Integer, Rule> rulesById;
    private final AdHocRuleCreator creator;
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private Map<RuleKey, NewAdHocRule> adHocRulesPersist = new HashMap<RuleKey, NewAdHocRule>();

    public RuleRepositoryImpl(AdHocRuleCreator creator, DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder) {
        this.creator = creator;
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void addOrUpdateAddHocRuleIfNeeded(RuleKey ruleKey, Supplier<NewAdHocRule> ruleSupplier) {
        this.ensureInitialized();
        Rule existingRule = this.rulesByKey.get(ruleKey);
        if (existingRule == null || existingRule.isAdHoc() && !this.adHocRulesPersist.containsKey(ruleKey)) {
            NewAdHocRule newAdHocRule = ruleSupplier.get();
            this.adHocRulesPersist.put(ruleKey, newAdHocRule);
            this.rulesByKey.put(ruleKey, new AdHocRuleWrapper(newAdHocRule));
        }
    }

    @Override
    public void saveOrUpdateAddHocRules(DbSession dbSession) {
        this.ensureInitialized();
        this.adHocRulesPersist.values().forEach(r -> this.persistAndIndex(dbSession, (NewAdHocRule)r));
    }

    private void persistAndIndex(DbSession dbSession, NewAdHocRule adHocRule) {
        RuleImpl rule = new RuleImpl(this.creator.persistAndIndex(dbSession, adHocRule, this.analysisMetadataHolder.getOrganization().toDto()));
        this.rulesById.put(rule.getId(), rule);
        this.rulesByKey.put(adHocRule.getKey(), rule);
    }

    @Override
    public Rule getByKey(RuleKey key) {
        RuleRepositoryImpl.verifyKeyArgument(key);
        this.ensureInitialized();
        Rule rule = this.rulesByKey.get(key);
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (String)"Can not find rule for key %s. This rule does not exist in DB", (Object[])new Object[]{key});
        return rule;
    }

    @Override
    public Optional<Rule> findByKey(RuleKey key) {
        RuleRepositoryImpl.verifyKeyArgument(key);
        this.ensureInitialized();
        return Optional.ofNullable(this.rulesByKey.get(key));
    }

    @Override
    public Rule getById(int id) {
        this.ensureInitialized();
        Rule rule = this.rulesById.get(id);
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (String)"Can not find rule for id %s. This rule does not exist in DB", (Object[])new Object[]{id});
        return rule;
    }

    @Override
    public Optional<Rule> findById(int id) {
        this.ensureInitialized();
        return Optional.ofNullable(this.rulesById.get(id));
    }

    private static void verifyKeyArgument(RuleKey key) {
        Objects.requireNonNull(key, "RuleKey can not be null");
    }

    private void ensureInitialized() {
        if (this.rulesByKey == null) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                this.loadRulesFromDb(dbSession);
            }
        }
    }

    private void loadRulesFromDb(DbSession dbSession) {
        this.rulesByKey = new HashMap<RuleKey, Rule>();
        this.rulesById = new HashMap<Integer, Rule>();
        String organizationUuid = this.analysisMetadataHolder.getOrganization().getUuid();
        Multimap deprecatedRuleKeysByRuleId = (Multimap)this.dbClient.ruleDao().selectAllDeprecatedRuleKeys(dbSession).stream().collect(MoreCollectors.index(DeprecatedRuleKeyDto::getRuleId));
        for (RuleDto ruleDto : this.dbClient.ruleDao().selectAll(dbSession, organizationUuid)) {
            RuleImpl rule = new RuleImpl(ruleDto);
            this.rulesByKey.put(ruleDto.getKey(), rule);
            this.rulesById.put(ruleDto.getId(), rule);
            deprecatedRuleKeysByRuleId.get((Object)ruleDto.getId()).forEach(t -> this.rulesByKey.put(RuleKey.of((String)t.getOldRepositoryKey(), (String)t.getOldRuleKey()), rule));
        }
    }

    private static class AdHocRuleWrapper
    implements Rule {
        private final NewAdHocRule addHocRule;

        private AdHocRuleWrapper(NewAdHocRule addHocRule) {
            this.addHocRule = addHocRule;
        }

        public NewAdHocRule getDelegate() {
            return this.addHocRule;
        }

        @Override
        public int getId() {
            throw new UnsupportedOperationException("Rule is not persisted, can't know the id");
        }

        @Override
        public RuleKey getKey() {
            return this.addHocRule.getKey();
        }

        @Override
        public String getName() {
            return this.addHocRule.getName();
        }

        @Override
        @CheckForNull
        public String getLanguage() {
            return null;
        }

        @Override
        public RuleStatus getStatus() {
            return RuleStatus.defaultStatus();
        }

        @Override
        @CheckForNull
        public RuleType getType() {
            return null;
        }

        @Override
        public boolean isExternal() {
            return true;
        }

        @Override
        public boolean isAdHoc() {
            return true;
        }

        @Override
        public Set<String> getTags() {
            return Collections.emptySet();
        }

        @Override
        @CheckForNull
        public DebtRemediationFunction getRemediationFunction() {
            return null;
        }

        @Override
        @CheckForNull
        public String getPluginKey() {
            return null;
        }
    }
}

