/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ReportModulesPath;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.issue.BaseInputFactory;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.ce.task.projectanalysis.issue.ComponentsWithUnprocessedIssues;
import org.sonar.ce.task.projectanalysis.issue.ProjectTrackerBaseLazyInput;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.db.DbClient;
import org.sonar.server.issue.IssueFieldsSetter;

public class TrackerBaseInputFactory
extends BaseInputFactory {
    private final ComponentIssuesLoader issuesLoader;
    private final DbClient dbClient;
    private final MovedFilesRepository movedFilesRepository;
    private final ReportModulesPath reportModulesPath;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final IssueFieldsSetter issueUpdater;
    private final ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues;

    public TrackerBaseInputFactory(ComponentIssuesLoader issuesLoader, DbClient dbClient, MovedFilesRepository movedFilesRepository, ReportModulesPath reportModulesPath, AnalysisMetadataHolder analysisMetadataHolder, IssueFieldsSetter issueUpdater, ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues) {
        this.issuesLoader = issuesLoader;
        this.dbClient = dbClient;
        this.movedFilesRepository = movedFilesRepository;
        this.reportModulesPath = reportModulesPath;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.issueUpdater = issueUpdater;
        this.componentsWithUnprocessedIssues = componentsWithUnprocessedIssues;
    }

    @Override
    public Input<DefaultIssue> create(Component component) {
        if (component.getType() == Component.Type.PROJECT) {
            return new ProjectTrackerBaseLazyInput(this.analysisMetadataHolder, this.componentsWithUnprocessedIssues, this.dbClient, this.issueUpdater, this.issuesLoader, this.reportModulesPath, component);
        }
        if (component.getType() == Component.Type.DIRECTORY) {
            return new EmptyTrackerBaseLazyInput(this.dbClient, component);
        }
        return new FileTrackerBaseLazyInput(this.dbClient, component, this.movedFilesRepository.getOriginalFile(component).orElse(null));
    }

    private static class EmptyTrackerBaseLazyInput
    extends BaseInputFactory.BaseLazyInput {
        private EmptyTrackerBaseLazyInput(DbClient dbClient, Component component) {
            super(dbClient, component, null);
        }

        protected List<DefaultIssue> loadIssues() {
            return Collections.emptyList();
        }
    }

    private class FileTrackerBaseLazyInput
    extends BaseInputFactory.BaseLazyInput {
        private FileTrackerBaseLazyInput(DbClient dbClient, @Nullable Component component, MovedFilesRepository.OriginalFile originalFile) {
            super(dbClient, component, originalFile);
        }

        protected List<DefaultIssue> loadIssues() {
            return TrackerBaseInputFactory.this.issuesLoader.loadOpenIssues(this.effectiveUuid);
        }
    }
}

