/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.api.measurecomputer.MeasureComputerContextImpl;
import org.sonar.ce.task.projectanalysis.api.measurecomputer.MeasureComputerWrapper;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesRepository;
import org.sonar.ce.task.projectanalysis.measure.MeasureComputersHolder;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;

public class MeasureComputersVisitor
extends TypeAwareVisitorAdapter {
    private static final Logger LOGGER = Loggers.get(MeasureComputersVisitor.class);
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final ConfigurationRepository settings;
    private final MeasureComputersHolder measureComputersHolder;
    private final ComponentIssuesRepository componentIssuesRepository;

    public MeasureComputersVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ConfigurationRepository settings, MeasureComputersHolder measureComputersHolder, ComponentIssuesRepository componentIssuesRepository) {
        super(CrawlerDepthLimit.reportMaxDepth(Component.Type.FILE).withViewsMaxDepth(Component.Type.SUBVIEW), ComponentVisitor.Order.POST_ORDER);
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.settings = settings;
        this.measureComputersHolder = measureComputersHolder;
        this.componentIssuesRepository = componentIssuesRepository;
    }

    @Override
    public void visitAny(Component component) {
        MeasureComputerContextImpl context = new MeasureComputerContextImpl(component, this.settings, this.measureRepository, this.metricRepository, this.componentIssuesRepository);
        for (MeasureComputerWrapper measureComputerWrapper : this.measureComputersHolder.getMeasureComputers()) {
            context.setDefinition(measureComputerWrapper.getDefinition());
            MeasureComputer measureComputer = measureComputerWrapper.getComputer();
            LOGGER.trace("Measure computer '{}' is computing component {}", (Object)measureComputer, (Object)component);
            measureComputer.compute((MeasureComputer.MeasureComputerContext)context);
        }
    }
}

