/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitymodel;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.measure.Rating;
import org.sonar.server.security.SecurityReviewRating;

public class SecurityReviewRatingVisitor
extends TypeAwareVisitorAdapter {
    private final MeasureRepository measureRepository;
    private final Metric nclocMetric;
    private final Metric securityHostspotsMetric;
    private final Metric securityReviewRatingMetric;

    public SecurityReviewRatingVisitor(MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(new CrawlerDepthLimit.Builder(Component.Type.PROJECT).withViewsMaxDepth(Component.Type.SUBVIEW), ComponentVisitor.Order.POST_ORDER);
        this.measureRepository = measureRepository;
        this.nclocMetric = metricRepository.getByKey("ncloc");
        this.securityHostspotsMetric = metricRepository.getByKey("security_hotspots");
        this.securityReviewRatingMetric = metricRepository.getByKey("security_review_rating");
    }

    @Override
    public void visitProject(Component project) {
        this.computeMeasure(project);
    }

    @Override
    public void visitView(Component view) {
        this.computeMeasure(view);
    }

    @Override
    public void visitSubView(Component subView) {
        this.computeMeasure(subView);
    }

    private void computeMeasure(Component component) {
        Optional<Measure> nclocMeasure = this.measureRepository.getRawMeasure(component, this.nclocMetric);
        Optional<Measure> securityHostspotsMeasure = this.measureRepository.getRawMeasure(component, this.securityHostspotsMetric);
        if (!nclocMeasure.isPresent() || !securityHostspotsMeasure.isPresent()) {
            return;
        }
        int ncloc = nclocMeasure.get().getIntValue();
        int securityHotspots = securityHostspotsMeasure.get().getIntValue();
        Rating rating = SecurityReviewRating.compute((int)ncloc, (int)securityHotspots);
        this.measureRepository.add(component, this.securityReviewRatingMetric, Measure.newMeasureBuilder().create(rating.getIndex(), rating.name()));
    }
}

