/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.formula.SumFormula;
import org.sonar.ce.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredFormula;
import org.sonar.ce.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredMetricKeys;
import org.sonar.ce.task.projectanalysis.formula.coverage.SingleWithUncoveredFormula;
import org.sonar.ce.task.projectanalysis.formula.coverage.SingleWithUncoveredMetricKeys;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;

public class CoverageMeasuresStep
implements ComputationStep {
    private static final ImmutableList<Formula> COVERAGE_FORMULAS = ImmutableList.of((Object)SumFormula.createIntSumFormula("lines_to_cover"), (Object)SumFormula.createIntSumFormula("uncovered_lines"), (Object)SumFormula.createIntSumFormula("conditions_to_cover"), (Object)SumFormula.createIntSumFormula("uncovered_conditions"), (Object)new CodeCoverageFormula(), (Object)new BranchCoverageFormula(), (Object)new LineCoverageFormula());
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final BatchReportReader reportReader;
    private final Metric linesToCoverMetric;
    private final Metric uncoveredLinesMetric;
    private final Metric conditionsToCoverMetric;
    private final Metric uncoveredConditionsMetric;

    public CoverageMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, BatchReportReader reportReader) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.reportReader = reportReader;
        this.linesToCoverMetric = metricRepository.getByKey("lines_to_cover");
        this.uncoveredLinesMetric = metricRepository.getByKey("uncovered_lines");
        this.conditionsToCoverMetric = metricRepository.getByKey("conditions_to_cover");
        this.uncoveredConditionsMetric = metricRepository.getByKey("uncovered_conditions");
    }

    public CoverageMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.linesToCoverMetric = metricRepository.getByKey("lines_to_cover");
        this.uncoveredLinesMetric = metricRepository.getByKey("uncovered_lines");
        this.conditionsToCoverMetric = metricRepository.getByKey("conditions_to_cover");
        this.uncoveredConditionsMetric = metricRepository.getByKey("uncovered_conditions");
        this.reportReader = null;
    }

    public void execute(ComputationStep.Context context) {
        if (this.reportReader != null) {
            new DepthTraversalTypeAwareCrawler(new FileCoverageVisitor(this.reportReader)).visit(this.treeRootHolder.getReportTreeRoot());
        }
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)COVERAGE_FORMULAS)).visit(this.treeRootHolder.getReportTreeRoot());
    }

    public String getDescription() {
        return "Compute coverage measures";
    }

    private static class LineCoverageFormula
    extends SingleWithUncoveredFormula {
        public LineCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("lines_to_cover", "uncovered_lines"), "line_coverage");
        }
    }

    private static class BranchCoverageFormula
    extends SingleWithUncoveredFormula {
        public BranchCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("conditions_to_cover", "uncovered_conditions"), "branch_coverage");
        }
    }

    private static class CodeCoverageFormula
    extends LinesAndConditionsWithUncoveredFormula {
        public CodeCoverageFormula() {
            super(new LinesAndConditionsWithUncoveredMetricKeys("lines_to_cover", "conditions_to_cover", "uncovered_lines", "uncovered_conditions"), "coverage");
        }
    }

    private class FileCoverageVisitor
    extends TypeAwareVisitorAdapter {
        private final BatchReportReader reportReader;

        private FileCoverageVisitor(BatchReportReader reportReader) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER);
            this.reportReader = reportReader;
        }

        @Override
        public void visitFile(Component file) {
            try (CloseableIterator<ScannerReport.LineCoverage> lineCoverage = this.reportReader.readComponentCoverage(file.getReportAttributes().getRef());){
                int linesToCover = 0;
                int coveredLines = 0;
                int conditionsToCover = 0;
                int coveredConditions = 0;
                while (lineCoverage.hasNext()) {
                    ScannerReport.LineCoverage line = (ScannerReport.LineCoverage)lineCoverage.next();
                    if (line.getHasHitsCase() == ScannerReport.LineCoverage.HasHitsCase.HITS) {
                        ++linesToCover;
                        if (line.getHits()) {
                            ++coveredLines;
                        }
                    }
                    if (line.getHasCoveredConditionsCase() != ScannerReport.LineCoverage.HasCoveredConditionsCase.COVERED_CONDITIONS) continue;
                    conditionsToCover += line.getConditions();
                    coveredConditions += Math.min(line.getCoveredConditions(), line.getConditions());
                }
                if (linesToCover > 0) {
                    CoverageMeasuresStep.this.measureRepository.add(file, CoverageMeasuresStep.this.linesToCoverMetric, Measure.newMeasureBuilder().create(linesToCover));
                    CoverageMeasuresStep.this.measureRepository.add(file, CoverageMeasuresStep.this.uncoveredLinesMetric, Measure.newMeasureBuilder().create(linesToCover - coveredLines));
                }
                if (conditionsToCover > 0) {
                    CoverageMeasuresStep.this.measureRepository.add(file, CoverageMeasuresStep.this.conditionsToCoverMetric, Measure.newMeasureBuilder().create(conditionsToCover));
                    CoverageMeasuresStep.this.measureRepository.add(file, CoverageMeasuresStep.this.uncoveredConditionsMetric, Measure.newMeasureBuilder().create(conditionsToCover - coveredConditions));
                }
            }
        }
    }
}

