/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.alm;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.alm.ALM;
import org.sonar.db.alm.AlmAppInstallDto;
import org.sonar.db.alm.OrganizationAlmBindingDto;
import org.sonar.db.alm.OrganizationAlmBindingMapper;
import org.sonar.db.organization.OrganizationDto;

public class OrganizationAlmBindingDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public OrganizationAlmBindingDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public Optional<OrganizationAlmBindingDto> selectByOrganization(DbSession dbSession, OrganizationDto organization) {
        return this.selectByOrganizationUuid(dbSession, organization.getUuid());
    }

    public Optional<OrganizationAlmBindingDto> selectByOrganizationUuid(DbSession dbSession, String organizationUuid) {
        return Optional.ofNullable(OrganizationAlmBindingDao.getMapper(dbSession).selectByOrganizationUuid(organizationUuid));
    }

    public List<OrganizationAlmBindingDto> selectByOrganizations(DbSession dbSession, Collection<OrganizationDto> organizations) {
        return this.selectByOrganizationUuids(dbSession, (Collection)organizations.stream().map(OrganizationDto::getUuid).collect(MoreCollectors.toSet()));
    }

    public List<OrganizationAlmBindingDto> selectByOrganizationUuids(DbSession dbSession, Collection<String> organizationUuids) {
        return DatabaseUtils.executeLargeInputs(organizationUuids, uuids -> OrganizationAlmBindingDao.getMapper(dbSession).selectByOrganizationUuids((Collection<String>)uuids));
    }

    public Optional<OrganizationAlmBindingDto> selectByAlmAppInstall(DbSession dbSession, AlmAppInstallDto almAppInstall) {
        return Optional.ofNullable(OrganizationAlmBindingDao.getMapper(dbSession).selectByInstallationUuid(almAppInstall.getUuid()));
    }

    public List<OrganizationAlmBindingDto> selectByOrganizationAlmIds(DbSession dbSession, ALM alm, Collection<String> organizationAlmIds) {
        return DatabaseUtils.executeLargeInputs(organizationAlmIds, o -> OrganizationAlmBindingDao.getMapper(dbSession).selectByOrganizationAlmIds(alm.getId(), (List<String>)o));
    }

    public void insert(DbSession dbSession, OrganizationDto organization, AlmAppInstallDto almAppInstall, String url, String userUuid, boolean membersSync) {
        long now = this.system2.now();
        OrganizationAlmBindingDao.getMapper(dbSession).insert(new OrganizationAlmBindingDto().setUuid(this.uuidFactory.create()).setOrganizationUuid(organization.getUuid()).setAlmAppInstallUuid(almAppInstall.getUuid()).setAlmId(almAppInstall.getAlm()).setUrl(url).setUserUuid(userUuid).setMembersSyncEnabled(membersSync).setCreatedAt(now));
    }

    public void deleteByOrganization(DbSession dbSession, OrganizationDto organization) {
        OrganizationAlmBindingDao.getMapper(dbSession).deleteByOrganizationUuid(organization.getUuid());
    }

    public void deleteByAlmAppInstall(DbSession dbSession, AlmAppInstallDto almAppInstall) {
        OrganizationAlmBindingDao.getMapper(dbSession).deleteByAlmAppInstallUuid(almAppInstall.getUuid());
    }

    public void updateMembersSync(DbSession dbSession, OrganizationAlmBindingDto orgAlmBinding, boolean enabled) {
        OrganizationAlmBindingDao.getMapper(dbSession).updateMembersSync(orgAlmBinding.getUuid(), enabled);
    }

    private static OrganizationAlmBindingMapper getMapper(DbSession dbSession) {
        return (OrganizationAlmBindingMapper)dbSession.getMapper(OrganizationAlmBindingMapper.class);
    }
}

